<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$selfSigned = true;

$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

// Receber o ID da OS
$id_oss_chamado = $_POST['id_oss_chamado'] ?? '';

if (empty($id_oss_chamado)) {
    echo json_encode([
        'success' => false,
        'message' => 'ID da OS não fornecido'
    ]);
    exit;
}

try {
    $params = array(
        'qtype' => 'su_oss_chamado_arquivos.id_oss_chamado',
        'query' => $id_oss_chamado,
        'oper' => '=',
        'page' => '1',
        'rp' => '1000',
        'sortname' => 'su_oss_chamado_arquivos.id',
        'sortorder' => 'desc'
    );
    
    $api->get('su_oss_chamado_arquivos', $params);
    $retorno = $api->getRespostaConteudo(false);
    
    echo json_encode([
        'success' => true,
        'data' => $retorno,
        'message' => 'Arquivos listados com sucesso'
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao listar arquivos: ' . $e->getMessage()
    ]);
}
?>

