<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

// Configurações da API IXC (REAIS)
$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$selfSigned = true; // true para certificado auto assinado

// Receber o ID do login
$id = $_POST['id'] ?? '';

if (empty($id)) {
    echo json_encode([
        'success' => false,
        'message' => 'ID do login é obrigatório'
    ]);
    exit;
}

try {
    $api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);
    
    $params = array(
        'id' => intval($id) // ID LOGIN
    );
    
    $api->get('desconectar_clientes', $params);
    $retorno = $api->getRespostaConteudo(false);
    
    echo json_encode([
        'success' => true,
        'message' => 'Login desconectado com sucesso',
        'data' => $retorno
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao desconectar login: ' . $e->getMessage()
    ]);
}
?>
