<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$selfSigned = true;

$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

// Receber o ID da caixa
$id_caixa = $_POST['id_caixa_ftth'] ?? '';

if (empty($id_caixa)) {
    echo json_encode([
        'success' => false,
        'message' => 'ID da caixa não fornecido'
    ]);
    exit;
}

try {
    $params = array(
        'qtype' => 'rad_caixa_ftth.id',
        'query' => $id_caixa,
        'oper' => '=',
        'page' => '1',
        'rp' => '1',
        'sortname' => 'rad_caixa_ftth.id',
        'sortorder' => 'desc'
    );

    $api->get('rad_caixa_ftth', $params);
    $retorno = $api->getRespostaConteudo(false);
    $resultado = json_decode($retorno, true);

    if (isset($resultado['registros']) && !empty($resultado['registros'])) {
        $caixa = $resultado['registros'][0];
        echo json_encode([
            'success' => true,
            'descricao' => $caixa['descricao'] ?? null
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Caixa não encontrada'
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
