<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Configuração da API IXC
$ixc_host = 'https://app.core3.com.br/webservice/v1';
$ixc_token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';

try {
    // Verificar se recebeu o arquivo
    if (!isset($_FILES['arquivo'])) {
        throw new Exception('Nenhum arquivo foi enviado');
    }
    
    $id_oss_chamado = $_POST['id_oss_chamado'] ?? '';
    $descricao = $_POST['descricao'] ?? '';
    
    // IMPORTANTE: Descrição é obrigatória e não pode estar vazia
    if (empty($descricao)) {
        $descricao = 'Foto tirada pelo técnico';
    }
    
    if (empty($id_oss_chamado)) {
        throw new Exception('ID da OS não fornecido');
    }
    
    $arquivo = $_FILES['arquivo'];
    
    // Verificar se houve erro no upload
    if ($arquivo['error'] !== UPLOAD_ERR_OK) {
        throw new Exception('Erro no upload do arquivo: ' . $arquivo['error']);
    }
    
    error_log("=== UPLOAD ARQUIVO OS ===");
    error_log("ID OS: " . $id_oss_chamado);
    error_log("Descrição: " . $descricao);
    error_log("Arquivo: " . $arquivo['name']);
    error_log("Tamanho: " . $arquivo['size']);
    
    // URL da API
    $url = $ixc_host . '/su_oss_chamado_arquivos';
    
    // Preparar dados com CURLFile
    // classificacao_arquivo = "P" (Padrão)
    $postData = [
        'descricao' => $descricao,
        'local_arquivo' => new CURLFile($arquivo['tmp_name'], $arquivo['type'], $arquivo['name']),
        'id_oss_chamado' => $id_oss_chamado,
        'classificacao_arquivo' => 'P'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_USERPWD, $ixc_token);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    error_log("HTTP Code: " . $httpCode);
    error_log("Response: " . substr($response, 0, 500));
    
    if ($error) {
        throw new Exception('Erro cURL: ' . $error);
    }
    
    if ($httpCode !== 200) {
        throw new Exception('HTTP ' . $httpCode . ': ' . substr($response, 0, 300));
    }
    
    // Verificar se a resposta do IXC é um erro
    $responseData = json_decode($response, true);
    if (isset($responseData['type']) && $responseData['type'] === 'error') {
        throw new Exception('Erro IXC: ' . $responseData['message']);
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Arquivo anexado com sucesso!',
        'ixc_response' => $response
    ], JSON_UNESCAPED_UNICODE);
    
} catch (Exception $e) {
    error_log("ERRO ao fazer upload: " . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>
