<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$selfSigned = true;
$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

try {
    $id_cliente = $_POST['id_cliente'] ?? '';
    
    if (empty($id_cliente)) {
        throw new Exception('ID do cliente não fornecido');
    }
    
    // Buscar OS do cliente com filtro de assunto
    $params = array(
        'qtype' => 'su_oss_chamado.id_cliente',
        'query' => $id_cliente,
        'oper' => '=',
        'page' => '1',
        'rp' => '100',
        'sortname' => 'su_oss_chamado.id',
        'sortorder' => 'desc'
    );
    
    $api->get('su_oss_chamado', $params);
    $retorno = $api->getRespostaConteudo(false);
    
    $dados = json_decode($retorno, true);
    
    if (!$dados || !isset($dados['registros'])) {
        throw new Exception('Nenhuma OS encontrada');
    }
    
    // Filtrar apenas OS com id_assunto 27, 28 ou 31 e status F
    $osFiltradas = array_filter($dados['registros'], function($os) {
        $assuntosPermitidos = ['27', '28', '31', '35'];
        return in_array($os['id_assunto'], $assuntosPermitidos) && $os['status'] === 'F';
    });
    
    // Reindexar array
    $osFiltradas = array_values($osFiltradas);
    
    echo json_encode([
        'success' => true,
        'data' => json_encode([
            'page' => $dados['page'],
            'total' => count($osFiltradas),
            'registros' => $osFiltradas
        ]),
        'message' => count($osFiltradas) . ' OS encontrada(s)'
    ], JSON_UNESCAPED_UNICODE);
    
} catch (Exception $e) {
    error_log('Erro ao listar OS cliente: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>

