<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    // Log dos dados recebidos
    error_log("📦 Inserir Comodato - Dados recebidos: " . json_encode($input));
    
    $id_contrato = $input['id_contrato'] ?? '';
    $id_produto = $input['id_produto'] ?? '';
    $qtde_saida = $input['qtde_saida'] ?? '';
    $id_almox = $input['id_almox'] ?? '';
    $filial_id = $input['filial_id'] ?? '';
    
    if (empty($id_contrato) || empty($id_produto) || empty($qtde_saida)) {
        echo json_encode([
            'success' => false,
            'message' => 'Parâmetros obrigatórios não informados',
            'params' => $input
        ]);
        exit;
    }
    
    $host = 'https://app.core3.com.br/webservice/v1';
    $token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
    $selfSigned = true;
    
    $api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);
    
    // Preparar dados para inserir comodato
    $dados = array(
        'id_patrimonio' => '',
        'id_produto' => $id_produto,
        'mac' => '',
        'numero_serie' => '',
        'numero_patrimonial' => '',
        'descricao' => '',
        'data' => date('d/m/Y'), // Data atual
        'id_unidade' => '1',
        'id_almox' => $id_almox,
        'filial_id' => $filial_id,
        'id_login' => '',
        'qtde_saida' => $qtde_saida,
        'valor_unitario' => '0.10',
        'pcomissao' => '',
        'pdesconto' => '',
        'vdesconto' => '',
        'valor_total' => '0.10',
        'status_comodato' => 'E', // E = Entregue
        'id_devolucao' => '',
        'quantidade' => '',
        'patrimonio' => '',
        'id_classificacao_tributaria' => '1',
        'tipo' => 'S', // S = Saída
        'estoque' => 'S',
        'unidade_sigla' => 'UND',
        'fator_conversao' => '1.000000000',
        'id_contrato' => $id_contrato,
        'id_equipamento_tv' => '',
        'tipo_produto' => ''
    );
    
    error_log("📦 Dados enviados para IXC: " . json_encode($dados));
    
    $api->post('cliente_contrato_comodato', $dados);
    $resultado = $api->getRespostaConteudo(false);
    $resultadoData = json_decode($resultado, true);
    
    error_log("📦 Resposta do IXC: " . $resultado);
    
    // Verificar se teve erro na resposta do IXC
    if (isset($resultadoData['type']) && $resultadoData['type'] === 'error') {
        echo json_encode([
            'success' => false,
            'message' => $resultadoData['message'] ?? 'Erro ao inserir comodato',
            'ixc_response' => $resultadoData
        ]);
        exit;
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Comodato inserido com sucesso',
        'id' => $resultadoData['id'] ?? null,
        'data' => $resultadoData
    ]);
    
} catch (Exception $e) {
    error_log("❌ Erro ao inserir comodato: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
