<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, ixcsoft');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$selfSigned = true;
$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

try {
    $clienteId = $_POST['cliente_id'] ?? null;

    if (!$clienteId) {
        throw new Exception('ID do cliente não fornecido');
    }

    $params = array(
        'qtype' => 'cliente_contrato.id_cliente',
        'query' => $clienteId,
        'oper' => '=',
        'page' => '1',
        'rp' => '50',
        'sortname' => 'cliente_contrato.id',
        'sortorder' => 'desc'
    );

    $api->get('cliente_contrato', $params);
    $retorno = $api->getRespostaConteudo(false);

    echo json_encode(['success' => true, 'data' => $retorno, 'message' => 'Contratos obtidos com sucesso']);

} catch (Exception $e) {
    error_log('Erro ao listar contratos: ' . $e->getMessage());
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
