<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$id_chamado = $_POST['id_chamado'] ?? '';
$mensagem = $_POST['mensagem'] ?? '';

if (empty($id_chamado) || empty($mensagem)) {
    echo json_encode([
        'success' => false,
        'message' => 'ID do chamado e mensagem são obrigatórios'
    ]);
    exit;
}

try {
    $mensagemFinal = $mensagem . "\n\n_#incluído pelo cliente_";
    
    $host = 'https://app.core3.com.br/webservice/v1';
    $token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
    
    $params = array(
        'id_chamado' => intval($id_chamado),
        'id_evento' => 8,
        'mensagem' => $mensagemFinal,
        'status' => 'A',
        'tipo_cobranca' => 'NENHUM',
        'finaliza_processo' => 'N'
    );
    
    $ch = curl_init($host . '/su_oss_chamado_mensagem');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
    curl_setopt($ch, CURLOPT_USERPWD, $token);  // <-- CORRIGIDO!
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    // Se retornou 200, consideramos sucesso mesmo que a resposta esteja vazia
    if ($httpCode == 200) {
        echo json_encode([
            'success' => true,
            'message' => 'Mensagem inserida com sucesso'
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Falha ao inserir mensagem - HTTP ' . $httpCode,
            'response' => $response
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
