<?php
// Configuração simples para teste direto
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Configurações EFI
$clientId = 'Client_Id_fa3b44ec67109bb5173cabeb7e73c50da9056595';
$clientSecret = 'Client_Secret_dca55fea80685f8ce4201a4f7e2a8cd75c76e129';

// Log simples
$input = file_get_contents('php://input');
file_put_contents('efi-simple.log', date('Y-m-d H:i:s') . " - INPUT: " . $input . "\n", FILE_APPEND);

$data = json_decode($input, true);

if (!$data || !isset($data['action'])) {
    echo json_encode(['error' => 'Dados inválidos', 'received' => $input]);
    exit();
}

// URL da API EFI em produção
$efiUrl = 'https://cobrancas.api.efipay.com.br';

if ($data['action'] === 'auth') {
    // Fazer requisição direta para autenticação
    $authUrl = $efiUrl . '/v1/authorize';
    
    $postData = json_encode(['grant_type' => 'client_credentials']);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $authUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Basic ' . base64_encode($clientId . ':' . $clientSecret)
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    
    curl_close($ch);
    
    file_put_contents('efi-simple.log', date('Y-m-d H:i:s') . " - AUTH RESPONSE: HTTP $httpCode | " . $response . "\n", FILE_APPEND);
    
    if ($error) {
        echo json_encode(['error' => 'Erro cURL: ' . $error]);
    } else {
        // Retornar resposta da EFI diretamente
        http_response_code($httpCode);
        echo $response;
    }
} elseif ($data['action'] === 'one_step_payment') {
    // Fazer One Step Payment
    $paymentUrl = $efiUrl . '/v1/charge/one-step';
    
    // Converter valor para centavos corretamente
    $valorEmReais = floatval($data['valor']);
    $valorEmCentavos = intval($valorEmReais * 100);
    $parcelas = intval($data['parcelas'] ?? 1);
    
    // Log para debug
    file_put_contents('efi-simple.log', date('Y-m-d H:i:s') . " - ONE STEP DEBUG: Valor recebido: " . $data['valor'] . " | Valor em reais: " . $valorEmReais . " | Valor em centavos: " . $valorEmCentavos . " | Parcelas: " . $parcelas . "\n", FILE_APPEND);
    
    $postData = json_encode([
        "items" => [
            [
                "name" => $data['descricao'] ?? 'Teste Integração EFI',
                "value" => $valorEmCentavos,
                "amount" => 1
            ]
        ],
        "payment" => [
            "credit_card" => [
                "customer" => [
                    "name" => $data['nome_portador'] ?? 'Cliente Teste',
                    "cpf" => $data['cpf_portador'] ?? '12345678901',
                    "email" => $data['email'] ?? 'teste@exemplo.com',
                    "phone_number" => $data['telefone'] ?? '11999999999'
                ],
                "installments" => $parcelas,
                "payment_token" => $data['payment_token']
            ]
        ]
    ]);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $paymentUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $data['access_token']
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    
    curl_close($ch);
    
    file_put_contents('efi-simple.log', date('Y-m-d H:i:s') . " - ONE STEP RESPONSE: HTTP $httpCode | " . $response . "\n", FILE_APPEND);
    
    if ($error) {
        echo json_encode(['error' => 'Erro cURL: ' . $error]);
    } else {
        // Retornar resposta da EFI diretamente
        http_response_code($httpCode);
        echo $response;
    }
} else {
    echo json_encode(['error' => 'Ação não suportada: ' . $data['action']]);
}
?>


