<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Configuração da API IXC
$ixc_host = 'https://app.core3.com.br/webservice/v1';
$ixc_token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';

try {
    // Receber parâmetros
    $id_tecnico = $_POST['id_tecnico'] ?? '';
    $status = $_POST['status'] ?? '';
    $filtrar_hoje = $_POST['filtrar_hoje'] ?? '';
    
    error_log("=== LISTAR OS TECNICO ===");
    error_log("ID Técnico: " . $id_tecnico);
    error_log("Status: " . $status);
    error_log("Filtrar hoje: " . $filtrar_hoje);
    
    if (empty($id_tecnico)) {
        echo json_encode([
            'success' => false,
            'message' => 'ID do técnico não fornecido'
        ], JSON_UNESCAPED_UNICODE);
        exit;
    }
    
    // URL da API de OS
    $url = $ixc_host . '/su_oss_chamado';
    
    // Montar grid_param conforme filtros
    $grid_param = [];
    
    if (!empty($status)) {
        $grid_param[] = [
            'TB' => 'su_oss_chamado.status',
            'OP' => '=',
            'P' => $status
        ];
    }
    
    // Filtrar por data de fechamento = hoje
    if ($filtrar_hoje === 'S' && $status === 'F') {
        $hoje = date('Y-m-d');
        $amanha = date('Y-m-d', strtotime('+1 day'));
        
        $grid_param[] = [
            'TB' => 'su_oss_chamado.data_fechamento',
            'OP' => '>=',
            'P' => $hoje . ' 00:00:00'
        ];
        
        $grid_param[] = [
            'TB' => 'su_oss_chamado.data_fechamento',
            'OP' => '<',
            'P' => $amanha . ' 00:00:00'
        ];
    }
    
    $postData = [
        'qtype' => 'su_oss_chamado.id_tecnico',
        'query' => $id_tecnico,
        'oper' => '=',
        'page' => '1',
        'rp' => '100',
        'sortname' => 'su_oss_chamado.id',
        'sortorder' => 'desc'
    ];
    
    if (!empty($grid_param)) {
        $postData['grid_param'] = json_encode($grid_param);
    }
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_USERPWD, $ixc_token);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'ixcsoft: listar',
        'User-Agent: Mozilla/5.0'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_HEADER, false);
    
    error_log("Grid param: " . json_encode($grid_param));
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        throw new Exception('Erro cURL: ' . $error);
    }
    
    if ($httpCode !== 200) {
        throw new Exception('HTTP ' . $httpCode . ': ' . substr($response, 0, 300));
    }
    
    // Verificar se a resposta é JSON válido
    $decoded = json_decode($response, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        if (preg_match('/Ocorreu um erro[^<]*/', $response, $matches)) {
            $errorMsg = strip_tags($matches[0]);
        } else {
            $errorMsg = 'Resposta inválida da API IXC';
        }
        throw new Exception($errorMsg . ': ' . substr($response, 0, 300));
    }
    
    // Retornar os dados
    echo json_encode([
        'success' => true,
        'data' => $response
    ], JSON_UNESCAPED_UNICODE);
    
} catch (Exception $e) {
    error_log("ERRO ao buscar OS do técnico: " . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar ordens de serviço: ' . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>
