<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Log de debug
error_log("=== SALVAR TOKEN PUSH CHAMADO ===");
error_log("REQUEST_METHOD: " . $_SERVER['REQUEST_METHOD']);

try {
    // Aceitar JSON
    $input = file_get_contents('php://input');
    error_log("INPUT recebido: " . $input);
    
    $json = json_decode($input, true);
    error_log("JSON decodificado: " . print_r($json, true));
    
    $id_tecnico = $json['id_tecnico'] ?? null;
    $push_token = $json['push_token'] ?? null;
    $plataforma = $json['plataforma'] ?? 'unknown';
    $tipo = $json['tipo'] ?? (strpos($push_token, 'ExponentPushToken') === 0 ? 'expo' : 'fcm');
    
    error_log("ID Técnico: " . $id_tecnico);
    error_log("Push Token: " . $push_token);
    error_log("Plataforma: " . $plataforma);
    error_log("Tipo de token: " . $tipo);
    
    if (empty($id_tecnico) || empty($push_token)) {
        echo json_encode(['success' => false, 'message' => 'id_tecnico e push_token são obrigatórios']);
        exit;
    }
    
    // Arquivo para armazenar tokens (caminho absoluto para garantir que ambos os diretórios usem o mesmo arquivo)
    $tokensFile = '/var/www/html/core3tech-app/tokens-push.json';
    
    // Ler tokens existentes
    $tokens = [];
    if (file_exists($tokensFile)) {
        $content = file_get_contents($tokensFile);
        $tokens = json_decode($content, true) ?: [];
    }
    
    // Atualizar ou adicionar token do técnico
    $tokens[$id_tecnico] = [
        'push_token' => $push_token,
        'plataforma' => $plataforma,
        'tipo' => $tipo,
        'ultima_atualizacao' => date('Y-m-d H:i:s')
    ];
    
    // Salvar tokens
    file_put_contents($tokensFile, json_encode($tokens, JSON_PRETTY_PRINT));
    
    echo json_encode([
        'success' => true,
        'message' => 'Token push salvo com sucesso',
        'id_tecnico' => $id_tecnico
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>

