<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

try {
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    $id_login = $_POST['id_login'] ?? $data['id_login'] ?? null;
    if (empty($id_login)) {
        throw new Exception('ID do login não informado');
    }

    require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

    // Credenciais da API IXC
    $host = 'https://app.core3.com.br/webservice/v1';
    $token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
    $selfSigned = true;

    $api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

    // Passo 1: Obter o id_cliente_fibra pelo id_login
    $paramsFibra = array(
        'qtype' => 'radpop_radio_cliente_fibra.id_login',
        'query' => $id_login,
        'oper' => '=',
        'page' => '1',
        'rp' => '1',
        'sortname' => 'radpop_radio_cliente_fibra.id',
        'sortorder' => 'desc'
    );
    $api->get('radpop_radio_cliente_fibra', $paramsFibra);
    $retFibra = $api->getRespostaConteudo(false);
    $dadosFibra = json_decode($retFibra, true);

    if (!isset($dadosFibra['registros'][0]['id'])) {
        throw new Exception('Registro de fibra não encontrado para este id_login');
    }

    $id_cliente_fibra = $dadosFibra['registros'][0]['id'];

    // Passo 2: Reiniciar ONU usando a ação específica da API
    // O endpoint é radpop_radio_cliente_fibra_26379 (26379 = código da ação de reiniciar)
    $url = $host . '/radpop_radio_cliente_fibra_26379';
    $postData = json_encode(array('id' => $id_cliente_fibra));
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_USERPWD, $token);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json'
    ));
    
    $retorno = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        throw new Exception('Erro cURL: ' . $error);
    }
    
    if ($httpCode !== 200) {
        throw new Exception('HTTP ' . $httpCode . ': ' . substr($retorno, 0, 300));
    }
    
    $resultado = json_decode($retorno, true);
    
    // Verificar se houve erro na resposta
    if (isset($resultado['type']) && $resultado['type'] === 'error') {
        throw new Exception('Erro IXC: ' . ($resultado['message'] ?? 'Erro desconhecido'));
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'ONU reiniciada com sucesso!',
        'id_cliente_fibra' => $id_cliente_fibra,
        'response' => $resultado
    ], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    error_log("ERRO ao reiniciar ONU: " . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>

