<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, ixcsoft');
header('Cache-Control: no-cache, no-store, must-revalidate');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$selfSigned = true;

@ini_set('memory_limit', '512M');
@set_time_limit(60);

$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

try {
    $id_tecnico = $_POST['id_tecnico'] ?? null;
    $status = $_POST['status'] ?? null;
    $filtrar_hoje = $_POST['filtrar_hoje'] ?? 'N';

    if (!$id_tecnico) {
        throw new Exception('ID do técnico não fornecido');
    }

    $params = array(
        'qtype' => 'su_oss_chamado.id_tecnico',
        'query' => $id_tecnico,
        'oper' => '=',
        'rp' => '500',
        'sortname' => 'su_oss_chamado.data_abertura',
        'sortorder' => 'desc',
        'grid_param' => '[{"TB":"su_oss_chamado.status","OP":"IN","P":"AG,DS,EX"}]'
    );

    $api->get('su_oss_chamado', $params);
    $retorno = $api->getRespostaConteudo(false);
    $dados = json_decode($retorno, true);

    // Filtrar por status se fornecido
    if ($status && isset($dados['registros'])) {
        $dados['registros'] = array_filter($dados['registros'], function($os) use ($status) {
            return isset($os['status']) && $os['status'] === $status;
        });
        $dados['registros'] = array_values($dados['registros']); // Reindexar array
    }

    // Filtrar por data de hoje se solicitado
    if ($filtrar_hoje === 'S' && isset($dados['registros'])) {
        $dataHoje = date('Y-m-d');
        
        // Filtrar OS que foram finalizadas hoje (usando data_final)
        $dados['registros'] = array_filter($dados['registros'], function($os) use ($dataHoje) {
            $dataFinal = $os['data_final'] ?? '';
            
            // Ignorar datas vazias ou 0000-00-00
            if (empty($dataFinal) || strpos($dataFinal, '0000-00-00') === 0) {
                return false;
            }
            
            $dataOS = substr($dataFinal, 0, 10);
            return $dataOS === $dataHoje;
        });
        
        $dados['registros'] = array_values($dados['registros']); // Reindexar
    }

    echo json_encode(['success' => true, 'data' => json_encode($dados), 'message' => 'OS do técnico recuperadas com sucesso']);

} catch (Exception $e) {
    error_log("Erro na API de listar OS técnico: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>

