<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, ixcsoft');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$selfSigned = true;
$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

try {
    // Receber dados JSON
    $input = file_get_contents('php://input');
    error_log('📥 [COMODATO] Input recebido: ' . $input);
    
    $data = json_decode($input, true);
    error_log('📦 [COMODATO] Data decodificado: ' . json_encode($data));
    
    // Receber todos os dados do produto (já vêm do app)
    $id_contrato = $data['id_contrato'] ?? null;
    $id_produto = $data['id_produto'] ?? null;
    $qtde_saida = $data['qtde_saida'] ?? null;
    $id_almox = $data['id_almox'] ?? null;
    $filial_id = $data['filial_id'] ?? null;
    $id_unidade = $data['id_unidade'] ?? '1';
    $unidade_sigla = $data['unidade_sigla'] ?? 'UN';
    $fator_conversao = $data['fator_conversao'] ?? '1.000000000';
    $valor_unitario = floatval($data['valor_unitario'] ?? $data['produto_preco_base'] ?? 0);
    $id_class_fiscal = $data['id_class_fiscal'] ?? $data['produto_id_class_fiscal'] ?? '1';
    
    // Validar parâmetros obrigatórios
    if (!$id_contrato || !$id_produto || !$qtde_saida || !$id_almox || !$filial_id) {
        throw new Exception('Parâmetros obrigatórios não informados: id_contrato, id_produto, qtde_saida, id_almox, filial_id');
    }
    
    // Calcular valores
    $valor_total = floatval($qtde_saida) * $valor_unitario;
    
    // Dados para inserir comodato (formato correto da API IXC)
    $dados = array(
        'id_contrato' => $id_contrato,
        'id_produto' => $id_produto,
        'qtde_saida' => $qtde_saida,
        'quantidade' => '',
        'id_almox' => $id_almox,
        'filial_id' => $filial_id,
        'id_unidade' => $id_unidade,
        'status_comodato' => 'E', // E = Emprestado/Saída
        'data' => date('d/m/Y'),
        'tipo' => 'S', // S = Saída
        'estoque' => 'S',
        'fator_conversao' => $fator_conversao,
        'unidade_sigla' => $unidade_sigla,
        'valor_unitario' => number_format($valor_unitario, 2, '.', ''),
        'valor_total' => number_format($valor_total, 2, '.', ''),
        'id_classificacao_tributaria' => $id_class_fiscal,
        'pcomissao' => '',
        'pdesconto' => '',
        'vdesconto' => '',
        'id_patrimonio' => '',
        'mac' => '',
        'numero_serie' => '',
        'numero_patrimonial' => '',
        'descricao' => '',
        'id_login' => '',
        'id_devolucao' => '',
        'patrimonio' => '',
        'id_equipamento_tv' => '',
        'tipo_produto' => ''
    );
    
    // Inserir comodato via API IXC
    $api->post('cliente_contrato_comodato', $dados);
    $retorno = $api->getRespostaConteudo(false);
    
    echo json_encode([
        'success' => true,
        'data' => $retorno,
        'message' => 'Comodato inserido com sucesso'
    ]);
    
} catch (Exception $e) {
    error_log("Erro ao inserir comodato: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

