<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

try {
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);
    
    error_log('📥 Input recebido: ' . $input);
    
    $telefone = $_POST['telefone'] ?? ($data['telefone'] ?? null);
    $nome_cliente = $_POST['nome_cliente'] ?? ($data['nome_cliente'] ?? null);
    $endereco_cliente = $_POST['endereco_cliente'] ?? ($data['endereco_cliente'] ?? null);
    
    error_log('📱 Telefone original: ' . $telefone);
    error_log('👤 Nome: ' . $nome_cliente);
    error_log('📍 Endereço: ' . $endereco_cliente);
    
    if (empty($telefone) || empty($nome_cliente) || empty($endereco_cliente)) {
        throw new Exception('Dados incompletos: telefone, nome_cliente e endereco_cliente são obrigatórios');
    }
    
    // Formatar telefone para padrão internacional (+55...)
    $telefone_limpo = preg_replace('/\D/', '', $telefone);
    error_log('🔧 Telefone limpo: ' . $telefone_limpo);
    
    if (substr($telefone_limpo, 0, 2) !== '55') {
        $telefone_limpo = '55' . $telefone_limpo;
    }
    $telefone_formatado = '+' . $telefone_limpo;
    
    error_log('✅ Telefone formatado: ' . $telefone_formatado);
    
    // Preparar payload para OPA Suite
    $payload = [
        'contato' => [
            'canalCliente' => $telefone_formatado
        ],
        'template' => [
            '_id' => '679ceb99205b7b145a11eefa',
            'variaveis' => [$nome_cliente, $endereco_cliente]
        ],
        'canal' => '679ceb14f86d85f0e353fcfc'
    ];
    
    error_log('📦 Payload para OPA Suite: ' . json_encode($payload, JSON_PRETTY_PRINT));
    
    // Enviar para OPA Suite
    $ch = curl_init('https://suporte.core3.com.br/api/v1/template/send');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6IjYyYzQyMTEyOWZiMTUyMjEzYzI3MDRiYiIsImlhdCI6MTc2MjE4MDY1Mn0.Lpvv3sau7Od8uguMLWHZdeUz_ISEZe_lXz9AQZRt-6A',
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    error_log('📡 HTTP Code: ' . $httpCode);
    error_log('📡 Response: ' . substr($response, 0, 500));
    
    if ($error) {
        error_log('❌ Erro cURL: ' . $error);
        throw new Exception('Erro cURL: ' . $error);
    }
    
    if ($httpCode !== 200 && $httpCode !== 201) {
        error_log('❌ HTTP Error ' . $httpCode . ': ' . $response);
        throw new Exception('HTTP ' . $httpCode . ': ' . substr($response, 0, 300));
    }
    
    $resultado = json_decode($response, true);
    error_log('✅ Mensagem enviada com sucesso para: ' . $telefone_formatado);
    
    echo json_encode([
        'success' => true,
        'message' => 'WhatsApp enviado com sucesso',
        'telefone' => $telefone_formatado,
        'opa_response' => $resultado
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

