<?php
header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="fatura.pdf"');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Lidar com requisições OPTIONS (CORS preflight)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

//requerindo arquivo do webservice
require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1'; //IP do seu sistema
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9'; // token do usuário API
$selfSigned = true;
//true para certificado auto assinado (Certificado SSL - true para HTTPS ; false para HTTP)
$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

try {
    // Verificar se foi enviado o ID do boleto
    $boletoId = $_GET['boleto_id'] ?? null;
    
    if (!$boletoId) {
        throw new Exception('ID do boleto não fornecido');
    }
    
    // Parâmetros para obter o boleto
    $params = array(
        'boletos' => $boletoId, // ID do boleto
        'juro' => 'N', // Sem juros
        'multa' => 'N', // Sem multa
        'atualiza_boleto' => 'S', // Atualizar boleto
        'tipo_boleto' => 'arquivo', // Tipo arquivo
        'base64' => 'S', // Retornar em base64
        'layout_impressao' => '' // Layout padrão
    );
    
    $api->get('get_boleto', $params);
    $retorno = $api->getRespostaConteudo(false); //false para json | true para array
    
    // Decodificar o base64 e enviar como PDF
    $pdfBase64 = $retorno;
    $pdfData = base64_decode($pdfBase64);
    
    // Definir headers para PDF
    header('Content-Length: ' . strlen($pdfData));
    header('Cache-Control: no-cache, must-revalidate');
    header('Pragma: no-cache');
    
    // Enviar o PDF
    echo $pdfData;
    
} catch (Exception $e) {
    http_response_code(500);
    header('Content-Type: text/plain');
    echo 'Erro ao obter boleto: ' . $e->getMessage();
}
?>
