<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

try {
    $id_contrato = $_POST['id_contrato'] ?? ($_GET['id_contrato'] ?? '');
    if (empty($id_contrato)) {
        echo json_encode(['success' => false, 'message' => 'ID do contrato não fornecido']);
        exit;
    }

    require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');
    $host = 'https://app.core3.com.br/webservice/v1';
    $token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
    $selfSigned = true;

    $api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);
    $params = array(
        'qtype' => 'cliente_contrato.id',
        'query' => (string)$id_contrato,
        'oper' => '=',
        'page' => '1',
        'rp' => '1',
        'sortname' => 'cliente_contrato.id',
        'sortorder' => 'desc'
    );
    $api->get('cliente_contrato', $params);
    $ret = $api->getRespostaConteudo(false);
    $dados = json_decode($ret, true);

    if (!isset($dados['registros'][0])) {
        echo json_encode(['success' => false, 'message' => 'Contrato não encontrado']);
        exit;
    }

    $contrato = $dados['registros'][0];

    echo json_encode([
        'success' => true,
        'contrato' => [
            'id' => $contrato['id'] ?? '',
            'contrato' => $contrato['contrato'] ?? '',
            'id_plano' => $contrato['id_plano'] ?? '',
            'plano_descricao' => $contrato['plano_descricao'] ?? ($contrato['contrato_plano_venda_'] ?? ''),
        ]
    ]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>


