<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Recebe os dados do POST
$data = json_decode(file_get_contents('php://input'), true);
$email = $data['email'] ?? '';
$senha = $data['senha'] ?? '';

error_log("=== VALIDAR TÉCNICO ===");
error_log("Email: " . $email);

if (empty($email) || empty($senha)) {
    echo json_encode(['success' => false, 'message' => 'Email e senha são obrigatórios']);
    exit;
}

// Configuração da API IXC
require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');
$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:343929a438b6196da8dcb68a911099c95a07d56ffb8b17ff9f34a9a3ba550f6d';
$selfSigned = true;

try {
    $api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);
    
    // Buscar usuário por email
    $params = array(
        'qtype' => 'usuarios.email',
        'query' => $email,
        'oper' => '=',
        'page' => '1',
        'rp' => '1',
        'sortname' => 'usuarios.id',
        'sortorder' => 'desc'
    );
    
    $api->get('usuarios', $params);
    $retornoJson = $api->getRespostaConteudo(false);
    $retorno = json_decode($retornoJson, true);
    
    error_log("Retorno IXC: " . print_r($retorno, true));
    
    // Verifica se encontrou o usuário
    if (isset($retorno['registros']) && !empty($retorno['registros'])) {
        $usuario = $retorno['registros'][0];
        
        error_log("Usuário encontrado - ID: " . $usuario['id']);
        error_log("Funcionário (Técnico): " . ($usuario['funcionario'] ?? 'NÃO DEFINIDO'));
        
        // A senha no IXC está em hash SHA256
        $senhaHash = hash('sha256', $senha);
        
        // Valida a senha
        if ($usuario['senha'] === $senhaHash) {
            echo json_encode([
                'success' => true,
                'message' => 'Login realizado com sucesso',
                'usuario' => [
                    'id' => $usuario['id'],
                    'nome' => $usuario['nome'],
                    'email' => $usuario['email'],
                    'funcionario' => $usuario['funcionario'] ?? null,
                    'tipo' => $usuario['tipo'] ?? 'tecnico'
                ]
            ]);
        } else {
            error_log("Senha incorreta!");
            echo json_encode(['success' => false, 'message' => 'Senha incorreta']);
        }
    } else {
        error_log("Usuário não encontrado!");
        echo json_encode(['success' => false, 'message' => 'Usuário não encontrado']);
    }
    
} catch (Exception $e) {
    error_log("ERRO: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Erro ao conectar com a API: ' . $e->getMessage()]);
}
?>
