<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Configuração da API IXC
$ixc_host = 'https://app.core3.com.br/webservice/v1';
$ixc_token = '91:343929a438b6196da8dcb68a911099c95a07d56ffb8b17ff9f34a9a3ba550f6d';

try {
    // Receber o ID do contrato
    $id_contrato = $_POST['id_contrato'] ?? '';
    
    error_log("=== BUSCAR LOGINS CONTRATO ===");
    error_log("ID Contrato recebido: " . $id_contrato);
    
    if (empty($id_contrato)) {
        echo json_encode([
            'success' => false,
            'message' => 'ID do contrato não fornecido'
        ], JSON_UNESCAPED_UNICODE);
        exit;
    }
    
    // URL da API de logins
    $url = $ixc_host . '/radusuarios';
    
    $postData = [
        'qtype' => 'radusuarios.id_contrato',
        'query' => $id_contrato,
        'oper' => '=',
        'page' => '1',
        'rp' => '100',
        'sortname' => 'radusuarios.id',
        'sortorder' => 'desc'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_USERPWD, $ixc_token);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'ixcsoft: listar',
        'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_HEADER, false);
    
    error_log("Fazendo requisição para IXC Logins: " . $url);
    error_log("Dados enviados: " . http_build_query($postData));
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    error_log("Resposta IXC Logins - HTTP: " . $httpCode . ", Error: " . $error);
    error_log("Resposta IXC Logins (primeiros 300 chars): " . substr($response, 0, 300));
    
    if ($error) {
        throw new Exception('Erro cURL: ' . $error);
    }
    
    if ($httpCode !== 200) {
        throw new Exception('HTTP ' . $httpCode . ': ' . substr($response, 0, 300));
    }
    
    // Verificar se a resposta é JSON válido
    $decoded = json_decode($response, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Resposta inválida da API IXC');
    }
    
    // Processar logins e retornar apenas campos necessários
    if (isset($decoded['registros']) && count($decoded['registros']) > 0) {
        $logins = array_map(function($login) {
            return [
                'id' => $login['id'] ?? '',
                'login' => $login['login'] ?? '',
                'senha' => $login['senha'] ?? '',
                'status' => $login['status'] ?? '',
                'online' => $login['online'] ?? ''
            ];
        }, $decoded['registros']);
        
        echo json_encode([
            'success' => true,
            'logins' => $logins,
            'total' => count($logins)
        ], JSON_UNESCAPED_UNICODE);
    } else {
        echo json_encode([
            'success' => true,
            'logins' => [],
            'total' => 0
        ], JSON_UNESCAPED_UNICODE);
    }
    
} catch (Exception $e) {
    error_log("ERRO ao buscar logins: " . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar logins: ' . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>

