<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Lidar com requisições OPTIONS (CORS preflight)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

//requerindo arquivo do webservice
require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1'; //IP do seu sistema
$token = '91:343929a438b6196da8dcb68a911099c95a07d56ffb8b17ff9f34a9a3ba550f6d'; // token do usuário API
$selfSigned = true;
//true para certificado auto assinado (Certificado SSL - true para HTTPS ; false para HTTP)
$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

try {
    // Verificar se foi enviado o ID do boleto
    $boletoId = $_POST['boleto_id'] ?? null;
    
    if (!$boletoId) {
        throw new Exception('ID do boleto não fornecido');
    }
    
    // Parâmetros para obter o boleto
    $params = array(
        'boletos' => $boletoId, // ID do boleto
        'juro' => 'N', // Sem juros
        'multa' => 'N', // Sem multa
        'atualiza_boleto' => 'S', // Atualizar boleto
        'tipo_boleto' => 'arquivo', // Tipo arquivo
        'base64' => 'S', // Retornar em base64
        'layout_impressao' => '' // Layout padrão
    );
    
    $api->get('get_boleto', $params);
    $retorno = $api->getRespostaConteudo(false); //false para json | true para array
    
    // Retornar resposta em formato JSON
    echo json_encode([
        'success' => true,
        'data' => $retorno,
        'message' => 'Boleto obtido com sucesso'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao obter boleto: ' . $e->getMessage()
    ]);
}
?>
