<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Lidar com requisições OPTIONS (CORS preflight)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

//requerindo arquivo do webservice
require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1'; //IP do seu sistema
$token = '91:343929a438b6196da8dcb68a911099c95a07d56ffb8b17ff9f34a9a3ba550f6d'; // token do usuário API
$selfSigned = true;
//true para certificado auto assinado (Certificado SSL - true para HTTPS ; false para HTTP)
$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

try {
    // Verificar se foi enviado o ID do cliente
    $clienteId = $_POST['cliente_id'] ?? null;
    
    if (!$clienteId) {
        throw new Exception('ID do cliente não fornecido');
    }
    
    $params = array(
        'qtype' => 'fn_areceber.id_cliente', //consultando pelo ID do cliente
        'query' => $clienteId, //Informar o ID do cliente para a listagem dos boletos
        'oper' => '=', //parâmetro de igualdade, buscando ID igual ao cliente
        'rp' => '200000', //registro por página
        'sortname' => 'fn_areceber.data_vencimento', //ordenando pela data de vencimento
        'sortorder' => 'asc', //ordenação ascendente
        'grid_param' => json_encode(array(
            array('TB' => 'fn_areceber.liberado', 'OP' => '=', 'P' => 'S'), 
            array('TB' => 'fn_areceber.status', 'OP' => '=', 'P' => 'A')
        )) //liberado = S e status = A (Aberto)
    );
    
    $api->get('fn_areceber', $params);
    $retorno = $api->getRespostaConteudo(false); //false para json | true para array
    
    // Retornar resposta em formato JSON
    echo json_encode([
        'success' => true,
        'data' => $retorno,
        'message' => 'Faturas em aberto recuperadas com sucesso'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar faturas em aberto: ' . $e->getMessage()
    ]);
}
?>
