<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

// Configurações da API IXC (REAIS)
$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:343929a438b6196da8dcb68a911099c95a07d56ffb8b17ff9f34a9a3ba550f6d';
$selfSigned = true; // true para certificado auto assinado

// Receber o ID do login
$id = $_POST['id'] ?? '';

if (empty($id)) {
    echo json_encode([
        'success' => false,
        'message' => 'ID do login é obrigatório'
    ]);
    exit;
}

try {
    $api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);
    
    $params = array(
        'id' => intval($id) // ID LOGIN
    );
    
    $api->get('desconectar_clientes', $params);
    $retorno = $api->getRespostaConteudo(false);
    
    echo json_encode([
        'success' => true,
        'message' => 'Login desconectado com sucesso',
        'data' => $retorno
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao desconectar login: ' . $e->getMessage()
    ]);
}
?>
