<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

//requerindo arquivo do webservice
require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1'; //IP do seu sistema
$token = '91:343929a438b6196da8dcb68a911099c95a07d56ffb8b17ff9f34a9a3ba550f6d'; // token do usuário API
$selfSigned = true;
//true para certificado auto assinado (Certificado SSL - true para HTTPS ; false para HTTP)
$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

try {
    // Verificar se foi enviado o ID do contrato
    $contratoId = $_POST['contrato_id'] ?? null;
    
    if (!$contratoId) {
        throw new Exception('ID do contrato não fornecido');
    }
    
    // Parâmetros para desbloqueio de confiança
    $params = array(
        'id' => $contratoId // ID do contrato
    );
    
    $api->get('desbloqueio_confianca', $params);
    $retorno = $api->getRespostaConteudo(false); //false para json | true para array
    
    // Retornar resposta em formato JSON
    echo json_encode([
        'success' => true,
        'data' => $retorno,
        'message' => 'Desbloqueio de confiança realizado com sucesso'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao realizar desbloqueio de confiança: ' . $e->getMessage()
    ]);
}
?>
