<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$selfSigned = true;

$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

// Receber dados
$input = file_get_contents('php://input');
$data = json_decode($input, true);

$id_atendimento = $data['id_atendimento'] ?? '';

if (empty($id_atendimento)) {
    echo json_encode([
        'success' => false,
        'message' => 'ID do atendimento não informado'
    ]);
    exit;
}

try {
    $params = array(
        'qtype' => 'su_ticket.id',
        'query' => $id_atendimento,
        'oper' => '=',
        'page' => '1',
        'rp' => '1000',
        'sortname' => 'su_ticket.id',
        'sortorder' => 'desc'
    );

    $api->get('su_ticket', $params);
    $retorno = $api->getRespostaConteudo(false);
    $resultado = json_decode($retorno, true);

    // Log para debug
    error_log('📥 Retorno IXC su_ticket: ' . json_encode($resultado, JSON_PRETTY_PRINT));

    // IXC retorna array direto, não com 'type'
    if (isset($resultado['registros']) && !empty($resultado['registros'])) {
        $ticket = $resultado['registros'][0];
        echo json_encode([
            'success' => true,
            'id_wfl_processo' => $ticket['id_wfl_processo'] ?? null,
            'ticket' => $ticket
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Ticket não encontrado',
            'retorno_ixc' => $resultado
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
