<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Configuração da API IXC
$ixc_host = 'https://app.core3.com.br/webservice/v1';
$ixc_token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';

try {
    // Receber ID da OS
    $input = json_decode(file_get_contents('php://input'), true);
    $id_os = $input['id'] ?? '';
    
    if (empty($id_os)) {
        throw new Exception('ID da OS não fornecido');
    }
    
    error_log("=== GERAR PDF OS ===");
    error_log("ID OS: " . $id_os);
    
    // URL da API
    $url = $ixc_host . '/imprimir_jato_laser_os';
    
    $postData = ['id' => $id_os];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
    curl_setopt($ch, CURLOPT_USERPWD, $ixc_token);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    error_log("HTTP Code: " . $httpCode);
    error_log("Response (primeiros 200 chars): " . substr($response, 0, 200));
    
    if ($error) {
        throw new Exception('Erro cURL: ' . $error);
    }
    
    if ($httpCode !== 200) {
        throw new Exception('HTTP ' . $httpCode . ': ' . substr($response, 0, 300));
    }
    
    // Verificar se a resposta do IXC é um erro
    $responseData = json_decode($response, true);
    if (isset($responseData['type']) && $responseData['type'] === 'error') {
        throw new Exception('Erro IXC: ' . $responseData['message']);
    }
    
    // A resposta deve conter o PDF em base64
    echo json_encode([
        'success' => true,
        'pdf_base64' => $response,
        'id_os' => $id_os
    ], JSON_UNESCAPED_UNICODE);
    
} catch (Exception $e) {
    error_log("ERRO ao gerar PDF: " . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>
