<?php
// Log de debug
error_log("=== NOVA REQUISIÇÃO ===");
error_log("Method: " . $_SERVER['REQUEST_METHOD']);
error_log("POST data: " . print_r($_POST, true));
error_log("Headers: " . print_r(getallheaders(), true));

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, ixcsoft');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Configurações da API IXC
$ixc_host = 'https://app.core3.com.br/webservice/v1';
$ixc_token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';

try {
    $action = $_POST['action'] ?? 'cliente';
    error_log("Action: " . $action);
    
    if ($action === 'test') {
        error_log("Executando teste de conectividade");
        echo json_encode([
            'success' => true,
            'message' => 'Conectividade OK',
            'timestamp' => date('Y-m-d H:i:s'),
            'server_ip' => $_SERVER['SERVER_ADDR'] ?? 'unknown'
        ]);
            } elseif ($action === 'listar-contratos') {
                error_log("Executando listagem de contratos");
                
                $clienteId = $_POST['cliente_id'] ?? '';
                
                if (empty($clienteId)) {
                    throw new Exception('ID do cliente não fornecido');
                }
                
                // Listar contratos do cliente
                $url = $ixc_host . '/cliente_contrato';
                
                $postData = [
                    'qtype' => 'cliente_contrato.id_cliente',
                    'query' => $clienteId,
                    'oper' => '=',
                    'page' => '1',
                    'rp' => '20',
                    'sortname' => 'cliente_contrato.id',
                    'sortorder' => 'desc'
                ];
                
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_USERPWD, $ixc_token);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'ixcsoft: listar',
                    'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
                ]);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                curl_setopt($ch, CURLOPT_TIMEOUT, 30);
                curl_setopt($ch, CURLOPT_HEADER, false);
                
                error_log("Fazendo requisição para IXC contratos: " . $url);
                error_log("Dados enviados: " . http_build_query($postData));
                $response = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                $error = curl_error($ch);
                curl_close($ch);
                
                error_log("Resposta IXC contratos - HTTP: " . $httpCode . ", Error: " . $error);
                error_log("Resposta IXC contratos (primeiros 200 chars): " . substr($response, 0, 200));
                
                if ($error) {
                    throw new Exception('Erro cURL: ' . $error);
                }
                
                if ($httpCode !== 200) {
                    throw new Exception('HTTP ' . $httpCode . ': ' . substr($response, 0, 300));
                }
                
                // Verificar se a resposta é JSON válido
                $decoded = json_decode($response, true);
                if (json_last_error() !== JSON_ERROR_NONE) {
                    if (preg_match('/Ocorreu um erro[^<]*/', $response, $matches)) {
                        $errorMsg = strip_tags($matches[0]);
                    } else {
                        $errorMsg = 'Resposta inválida da API IXC';
                    }
                    throw new Exception($errorMsg . ': ' . substr($response, 0, 300));
                }
                
                echo $response;
                
            } elseif ($action === 'imprimir-contrato') {
                error_log("Executando impressão de contrato");
                
                $id_contrato = $_POST['id'] ?? '';
                
                if (!$id_contrato) {
                    throw new Exception('ID do contrato é obrigatório');
                }
                
                // Imprimir contrato usando WebserviceClient
                require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');
                $host = $ixc_host;
                $token = $ixc_token;
                $selfSigned = true;
                $api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);
                
                $params = array(
                    'id' => $id_contrato
                );
                
                $api->get('cliente_contrato_imprimir_contrato', $params);
                $retorno = $api->getRespostaConteudo(false);
                
                echo json_encode($retorno);
                
            } elseif ($action === 'desbloqueio-confianca') {
                error_log("Executando desbloqueio de confiança");
                
                $contratoId = $_POST['id_contrato'] ?? '';
                
                if (empty($contratoId)) {
                    throw new Exception('ID do contrato não fornecido');
                }
                
                // Desbloqueio de confiança
                $url = $ixc_host . '/desbloqueio_confianca';
                
                $postData = [
                    'id' => $contratoId
                ];
                
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_USERPWD, $ixc_token);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'ixcsoft: listar',
                    'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
                ]);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                curl_setopt($ch, CURLOPT_TIMEOUT, 30);
                curl_setopt($ch, CURLOPT_HEADER, false);
                
                error_log("Fazendo requisição para IXC desbloqueio: " . $url);
                error_log("Dados enviados: " . http_build_query($postData));
                $response = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                $error = curl_error($ch);
                curl_close($ch);
                
                error_log("Resposta IXC desbloqueio - HTTP: " . $httpCode . ", Error: " . $error);
                error_log("Resposta IXC desbloqueio (primeiros 200 chars): " . substr($response, 0, 200));
                
                if ($error) {
                    throw new Exception('Erro cURL: ' . $error);
                }
                
                if ($httpCode !== 200) {
                    throw new Exception('HTTP ' . $httpCode . ': ' . substr($response, 0, 300));
                }
                
                echo $response;
                
            } elseif ($action === 'cliente') {
        error_log("Executando busca de cliente");
        
        // Corrigir formato do telefone se necessário
        if (isset($_POST['qtype']) && $_POST['qtype'] === 'telefone_celular') {
            $query = $_POST['query'] ?? '';
            // Remover caracteres especiais e manter apenas números
            $telefoneLimpo = preg_replace('/[^0-9]/', '', $query);
            // Formatar como (XX) XXXXX-XXXX
            if (strlen($telefoneLimpo) == 11) {
                $telefoneFormatado = '(' . substr($telefoneLimpo, 0, 2) . ') ' . substr($telefoneLimpo, 2, 5) . '-' . substr($telefoneLimpo, 7, 4);
                $_POST['query'] = $telefoneFormatado;
                error_log("Telefone corrigido: " . $telefoneFormatado);
            }
        }
        
        // Buscar cliente por telefone (sem validar senha ainda)
        $url = $ixc_host . '/cliente';
        
        // Remover senha dos dados POST para buscar apenas por telefone
        $postData = $_POST;
        unset($postData['senha']);
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_USERPWD, $ixc_token);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'ixcsoft: listar',
            'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_HEADER, false);
        
        error_log("Fazendo requisição para IXC: " . $url);
        error_log("Dados enviados (sem senha): " . http_build_query($postData));
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        curl_close($ch);
        
        error_log("Resposta IXC - HTTP: " . $httpCode . ", Error: " . $error);
        error_log("Resposta IXC (primeiros 200 chars): " . substr($response, 0, 200));
        
        if ($error) {
            throw new Exception('Erro cURL: ' . $error);
        }
        
        if ($httpCode !== 200) {
            throw new Exception('HTTP ' . $httpCode . ': ' . $response);
        }
        
        // Verificar se a resposta é JSON válido
        $decoded = json_decode($response, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            // Extrair mensagem de erro do HTML
            if (preg_match('/Ocorreu um erro[^<]*/', $response, $matches)) {
                $errorMsg = strip_tags($matches[0]);
            } else {
                $errorMsg = 'Resposta inválida da API IXC';
            }
            throw new Exception($errorMsg . ': ' . substr($response, 0, 300));
        }
        
        echo $response;
        
    } else {
        throw new Exception('Ação não especificada');
    }
    
} catch (Exception $e) {
    error_log("ERRO: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage()
    ]);
}
?>
