#!/bin/bash

echo "🚀 UPLOAD AUTOMÁTICO DO SISTEMA"
echo "================================"
echo "Servidor: 192.168.2.16:60111"
echo "Destino: /var/www/html/sistema/"
echo ""

# Configurações
SERVIDOR="root@192.168.2.16"
PORTA="60111"
DESTINO="/var/www/html/sistema"
ARQUIVOS=(
    "teste_bloqueio.php"
    "WebserviceClient.php"
    "confApi.php"
    "config.php"
    "mapeamento-planos.php"
    "inserir-contrato-ixc.php"
    "proxy-chip.php"
    "linhas.php"
    "consumos.php"
    "buscar-plano.php"
)

# 1. Enviar arquivos principais
echo "📁 Enviando arquivos do sistema..."
for arquivo in "${ARQUIVOS[@]}"; do
    if [ -f "$arquivo" ]; then
        echo "📤 Enviando: $arquivo"
        scp -P $PORTA "$arquivo" $SERVIDOR:$DESTINO/
        if [ $? -eq 0 ]; then
            echo "✅ $arquivo enviado com sucesso!"
        else
            echo "❌ Erro ao enviar $arquivo"
        fi
    else
        echo "⚠️ Arquivo não encontrado: $arquivo"
    fi
done

# 2. Enviar arquivo de configuração
echo ""
echo "⚙️ Enviando configuração..."
scp -P $PORTA config_final.php $SERVIDOR:$DESTINO/config.php
if [ $? -eq 0 ]; then
    echo "✅ Configuração enviada com sucesso!"
else
    echo "❌ Erro ao enviar configuração"
fi

# 3. Verificar arquivos no servidor
echo ""
echo "🔍 Verificando arquivos no servidor..."
ssh -p $PORTA $SERVIDOR "ls -la $DESTINO/ && echo '' && echo '📝 Verificando logs:' && ls -la $DESTINO/logs/"

echo ""
echo "🎉 UPLOAD CONCLUÍDO!"
echo "🌐 Acesse: http://192.168.2.16/sistema"
echo "📁 Arquivos em: $DESTINO"
echo ""
echo "💡 Próximo passo: Testar sistema funcionando"

