// ========================================
// TESTE DAS APIs NO CONSOLE DO NAVEGADOR
// ========================================
// 
// Copie e cole estes comandos no console do navegador
// para testar as APIs e ver o que elas retornam

console.log('🚀 INICIANDO TESTES DAS APIs...');

// ========================================
// TESTE 1: API de Subscription Details
// ========================================
console.log('\n🔍 TESTE 1: Testando API Subscription Details...');

// Substitua o MSISDN por um que você tenha
const msisdnTeste = '5575976024146'; // ⚠️ ALTERE PARA UM MSISDN VÁLIDO

async function testarSubscriptionDetails() {
    try {
        console.log(`📡 Testando: /api/Subscription/${msisdnTeste}/details`);
        
        const response = await fetch(`proxy-chip.php?rota=${encodeURIComponent(`/api/Subscription/${msisdnTeste}/details`)}`);
        console.log('📊 Status da resposta:', response.status, response.statusText);
        
        const data = await response.json();
        console.log('📋 Dados completos da resposta:', data);
        
        // Verificar campos específicos
        if (data && !data.error) {
            console.log('✅ Resposta válida encontrada!');
            console.log('🔍 Campos disponíveis:', Object.keys(data));
            console.log('📱 MSISDN:', data.msisdn);
            console.log('🆔 AccountId:', data.accountId);
            console.log('🆔 ID:', data.id);
            console.log('🆔 SubscriberId:', data.subscriberId);
        } else {
            console.log('❌ Erro na resposta:', data.error);
            console.log('📊 HTTP Code:', data.http_code);
            console.log('📋 API Response:', data.api_response);
        }
    } catch (error) {
        console.error('❌ Erro ao testar API:', error);
    }
}

// ========================================
// TESTE 2: API de Subscriber (antiga)
// ========================================
console.log('\n🔍 TESTE 2: Testando API Subscriber (antiga)...');

async function testarSubscriber() {
    try {
        console.log(`📡 Testando: /api/Subscriber/${msisdnTeste}/msisdn`);
        
        const response = await fetch(`proxy-chip.php?rota=${encodeURIComponent(`/api/Subscriber/${msisdnTeste}/msisdn`)}`);
        console.log('📊 Status da resposta:', response.status, response.statusText);
        
        const data = await response.json();
        console.log('📋 Dados completos da resposta:', data);
        
        if (data && !data.error) {
            console.log('✅ Resposta válida encontrada!');
            console.log('🔍 Campos disponíveis:', Object.keys(data));
        } else {
            console.log('❌ Erro na resposta:', data.error);
        }
    } catch (error) {
        console.error('❌ Erro ao testar API Subscriber:', error);
    }
}

// ========================================
// TESTE 3: Verificar todas as rotas disponíveis
// ========================================
console.log('\n🔍 TESTE 3: Verificando rotas disponíveis...');

async function verificarRotasDisponiveis() {
    const rotasParaTestar = [
        `/api/Subscription/${msisdnTeste}/details`,
        `/api/Subscriber/${msisdnTeste}/msisdn`,
        `/api/Subscription/${msisdnTeste}/consumption`,
        `/api/Subscription/${msisdnTeste}`
    ];
    
    for (const rota of rotasParaTestar) {
        try {
            console.log(`\n📡 Testando rota: ${rota}`);
            const response = await fetch(`proxy-chip.php?rota=${encodeURIComponent(rota)}`);
            console.log(`📊 Status: ${response.status} ${response.statusText}`);
            
            if (response.ok) {
                const data = await response.json();
                console.log('✅ Resposta válida:', data);
                
                // Verificar se tem accountId
                if (data && (data.accountId || data.id || data.subscriberId)) {
                    console.log('🎉 ACCOUNTID ENCONTRADO!');
                    console.log('🔍 AccountId:', data.accountId);
                    console.log('🔍 ID:', data.id);
                    console.log('🔍 SubscriberId:', data.subscriberId);
                }
            } else {
                console.log('❌ Erro HTTP:', response.status);
            }
        } catch (error) {
            console.error('❌ Erro:', error.message);
        }
    }
}

// ========================================
// EXECUTAR TODOS OS TESTES
// ========================================
console.log('\n🚀 EXECUTANDO TODOS OS TESTES...\n');

// Executar testes sequencialmente
async function executarTodosTestes() {
    await testarSubscriptionDetails();
    await testarSubscriber();
    await verificarRotasDisponiveis();
    
    console.log('\n🎯 TESTES CONCLUÍDOS!');
    console.log('📋 Verifique os resultados acima para identificar qual API retorna o accountId');
}

// Executar automaticamente
executarTodosTestes();

// ========================================
// COMANDOS INDIVIDUAIS (execute um por vez se preferir)
// ========================================
console.log('\n📝 COMANDOS INDIVIDUAIS:');
console.log('• testarSubscriptionDetails() - Testa a API principal');
console.log('• testarSubscriber() - Testa a API antiga');
console.log('• verificarRotasDisponiveis() - Testa todas as rotas');
console.log('• executarTodosTestes() - Executa todos os testes');
