#!/bin/bash

# Script para iniciar o servidor PHP da API IXCsoft
# Autor: Assistente AI
# Data: $(date)

echo "🚀 Iniciando servidor da API IXCsoft..."
echo ""

# Verificar se o PHP está instalado
if ! command -v php &> /dev/null; then
    echo "❌ Erro: PHP não está instalado!"
    echo "💡 Instale o PHP primeiro:"
    echo "   - macOS: brew install php"
    echo "   - Ubuntu/Debian: sudo apt install php"
    echo "   - Windows: Baixe do php.net"
    exit 1
fi

# Verificar versão do PHP
PHP_VERSION=$(php -v | head -n1 | cut -d' ' -f2 | cut -d'.' -f1,2)
echo "✅ PHP $PHP_VERSION detectado"

# Verificar extensão cURL
if ! php -m | grep -q "curl"; then
    echo "❌ Erro: Extensão cURL não está habilitada!"
    echo "💡 Habilite a extensão cURL no php.ini"
    exit 1
fi
echo "✅ Extensão cURL habilitada"

# Verificar se os arquivos necessários existem
if [ ! -f "confApi.php" ]; then
    echo "❌ Erro: confApi.php não encontrado!"
    exit 1
fi

if [ ! -f "WebserviceClient.php" ]; then
    echo "❌ Erro: WebserviceClient.php não encontrado!"
    exit 1
fi

if [ ! -f "consulta.php" ]; then
    echo "❌ Erro: consulta.php não encontrado!"
    exit 1
fi

if [ ! -f "server.php" ]; then
    echo "❌ Erro: server.php não encontrado!"
    exit 1
fi

echo "✅ Todos os arquivos necessários encontrados"
echo ""

# Configurações do servidor
HOST="localhost"
PORT="8000"

echo "🌐 Configurações do servidor:"
echo "   Host: $HOST"
echo "   Porta: $PORT"
echo ""

echo "📱 URLs de acesso:"
echo "   Interface web: http://$HOST:$PORT"
echo "   API direta: http://$HOST:$PORT/consulta.php?id=1"
echo ""

echo "⏹️  Para parar o servidor, pressione Ctrl+C"
echo ""

# Iniciar o servidor
echo "🚀 Iniciando servidor em http://$HOST:$PORT..."
echo ""

php -S $HOST:$PORT server.php



