<?php
session_start();
if (!isset($_SESSION['bora_email']) || !isset($_SESSION['bora_password'])) {
    header('Location: login.php');
    exit;
}
$email = $_SESSION['bora_email'];
$password = $_SESSION['bora_password'];
header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$input = file_get_contents('php://input');
$data = json_decode($input, true);
if (!$data || !isset($data['name'], $data['document'], $data['pmsisdn'], $data['msisdn'], $data['email'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Dados obrigatórios ausentes.']);
    exit;
}
$baseUrl = 'https://app.boramvno.com.br/appapi';
$auth = base64_encode("$email:$password");
// 1. Autenticação básica para obter token
$ch = curl_init($baseUrl . '/api/Authentication/basic');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Authorization: Basic $auth",
    "Content-Type: application/json"
]);
curl_setopt($ch, CURLOPT_POSTFIELDS, '{}');
$authResponse = curl_exec($ch);
$headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
$header = substr($authResponse, 0, $headerSize);
$body   = substr($authResponse, $headerSize);
curl_close($ch);
$authResult = json_decode($body, true);
$token = null;
if (isset($authResult['token'])) {
    $token = $authResult['token'];
} else if (preg_match('/x-access-token:\s*(.+)/i', $header, $matches)) {
    $token = trim($matches[1]);
}
if (!$token) {
    http_response_code(401);
    echo json_encode(['error' => 'Falha ao autenticar na API Boramvno.']);
    exit;
}
// 2. Solicitar Portabilidade
$url = $baseUrl . '/api/Portability';
$ch2 = curl_init($url);
curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch2, CURLOPT_POST, true);
curl_setopt($ch2, CURLOPT_HTTPHEADER, [
    "Authorization: Bearer $token",
    "Content-Type: application/json"
]);
curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch2, CURLOPT_TIMEOUT, 20);
$response = curl_exec($ch2);
$httpCode = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
$error = curl_error($ch2);
curl_close($ch2);
if ($error) {
    http_response_code(500);
    echo json_encode(['error' => 'Erro ao solicitar portabilidade: ' . $error]);
    exit;
}
http_response_code($httpCode);
echo $response ? $response : json_encode(['error' => 'Resposta vazia da API Boramvno']);
