#!/bin/bash

echo "🚀 SETUP SIMPLES - SEM COMPLICAÇÕES"
echo "===================================="

# 1. Criar diretórios
echo "📁 Criando diretórios..."
mkdir -p /var/www/html/sistema
mkdir -p /var/www/html/sistema/logs
chown -R www-data:www-data /var/www/html/sistema
chmod -R 755 /var/www/html/sistema
chmod -R 777 /var/www/html/sistema/logs
echo "✅ Diretórios criados!"

# 2. Criar banco de dados
echo ""
echo "🗄️ Criando banco de dados..."
mysql -e "CREATE DATABASE IF NOT EXISTS ixcprovedor;"
echo "✅ Banco criado!"

# 3. Configurar cron
echo ""
echo "⏰ Configurando cron..."
(crontab -l 2>/dev/null; echo "0 6 * * * /usr/bin/php /var/www/html/sistema/teste_bloqueio.php >> /var/log/desativacao_recorrencia.log 2>&1") | crontab -
echo "✅ Cron configurado!"

# 4. Verificar PHP
echo ""
echo "🔍 Verificando PHP..."
php -v
echo ""
echo "📋 Extensões disponíveis:"
php -m | grep -E "(curl|xml|mbstring|mysql|json)" || echo "⚠️ Algumas extensões podem não estar disponíveis"

echo ""
echo "🎉 SETUP CONCLUÍDO!"
echo "📁 Sistema em: /var/www/html/sistema"
echo "🌐 Acesse: http://192.168.2.16/sistema"
echo ""
echo "💡 Próximo passo: Upload dos arquivos do sistema"

