#!/bin/bash

echo "🚀 INICIANDO CONFIGURAÇÃO DO SERVIDOR..."

# Atualizar sistema
echo "📦 Atualizando repositórios..."
apt-get update

# Instalar extensões PHP necessárias
echo "🔧 Instalando extensões PHP..."
apt-get install -y php7.4-curl php7.4-xml php7.4-mbstring php7.4-mysql php7.4-json

# Verificar extensões instaladas
echo "✅ Verificando extensões PHP instaladas..."
php -m | grep -E "(curl|xml|mbstring|mysql|json)"

# Criar diretório para o sistema
echo "📁 Criando diretório do sistema..."
mkdir -p /var/www/html/sistema
chown -R www-data:www-data /var/www/html/sistema
chmod -R 755 /var/www/html/sistema

# Criar diretório de logs
echo "📝 Criando diretório de logs..."
mkdir -p /var/www/html/sistema/logs
chmod -R 777 /var/www/html/sistema/logs

# Verificar status dos serviços
echo "🔍 Verificando status dos serviços..."
systemctl status apache2
systemctl status mysql

echo "✅ CONFIGURAÇÃO CONCLUÍDA!"
echo "📁 Sistema será instalado em: /var/www/html/sistema"
echo "📝 Logs em: /var/www/html/sistema/logs"

