<?php
// Core3Chip - Consulta Avançada de Cliente Boramvno
$currentTime = date('H:i:s');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Consultar Cliente - Core3Chip</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <style>
        body { min-height: 100vh; background: linear-gradient(135deg, #0f2027 0%, #2c5364 100%); display: flex; align-items: center; justify-content: center; font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif; margin: 0; }
        .container { background: rgba(255,255,255,0.97); border-radius: 32px; box-shadow: 0 8px 40px 0 rgba(37,99,235,0.18), 0 1.5px 8px 0 rgba(16,185,129,0.10); padding: 56px 40px 48px 40px; max-width: 520px; width: 100%; display: flex; flex-direction: column; align-items: center; gap: 36px; position: relative; }
        .logo-img { width: 195px; height: 130px; object-fit: contain; object-position: center; margin-bottom: 12px; filter: drop-shadow(0 4px 24px #2563eb33); background: transparent; border-radius: 18px; }
        .search-section { width: 100%; background: #f1f5f9; border-radius: 18px; padding: 24px 18px 18px 18px; box-shadow: 0 2px 12px 0 rgba(37,99,235,0.06); margin-bottom: 10px; }
        .search-title h2 { font-size: 1.3rem; font-weight: 700; color: #2563eb; margin: 0 0 4px 0; }
        .search-title p { font-size: 1rem; color: #64748b; margin: 0 0 18px 0; }
        .search-form { display: flex; flex-direction: column; gap: 14px; }
        .form-group { display: flex; flex-direction: column; gap: 6px; }
        .form-label { font-size: 0.98rem; color: #1e293b; font-weight: 500; }
        .form-input { padding: 12px 14px; border-radius: 8px; border: 1.5px solid #cbd5e1; font-size: 1.08rem; outline: none; transition: border 0.2s; }
        .form-input:focus { border: 1.5px solid #2563eb; }
        .search-btn { padding: 13px 0; border: none; border-radius: 10px; font-size: 1.08rem; font-weight: 600; color: #fff; background: linear-gradient(90deg, #2563eb 0%, #10b981 100%); box-shadow: 0 2px 12px 0 rgba(37,99,235,0.10); cursor: pointer; display: flex; align-items: center; justify-content: center; gap: 10px; transition: background 0.2s, transform 0.2s, box-shadow 0.2s; outline: none; letter-spacing: 0.5px; }
        .search-btn .material-icons { font-size: 1.3em; vertical-align: middle; }
        .search-btn:hover { background: linear-gradient(90deg, #10b981 0%, #2563eb 100%); transform: translateY(-2px) scale(1.03); box-shadow: 0 6px 24px 0 rgba(16,185,129,0.13); }
        .loading { display: none; align-items: center; flex-direction: column; gap: 10px; margin: 18px 0; }
        .spinner { width: 32px; height: 32px; border: 4px solid #e0e7ef; border-top: 4px solid #2563eb; border-radius: 50%; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
        .error-message, .success-message { display: none; margin: 10px 0 0 0; padding: 10px 18px; border-radius: 8px; font-size: 1.02rem; font-weight: 500; }
        .error-message { background: #fee2e2; color: #b91c1c; border: 1.5px solid #f87171; }
        .success-message { background: #d1fae5; color: #065f46; border: 1.5px solid #10b981; }
        .results-section { width: 100%; background: #f8fafc; border-radius: 18px; padding: 24px 18px 18px 18px; box-shadow: 0 2px 12px 0 rgba(37,99,235,0.06); margin-top: 10px; }
        .results-title { font-size: 1.15rem; font-weight: 700; color: #2563eb; margin: 0 0 18px 0; }
        .client-form { width: 100%; }
        .form-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 14px 18px; }
        .form-field { display: flex; flex-direction: column; gap: 4px; }
        .field-label { font-size: 0.97rem; color: #1e293b; font-weight: 500; }
        .field-value { padding: 10px 10px; border-radius: 7px; border: 1.2px solid #cbd5e1; font-size: 1.01rem; outline: none; background: #fff; color: #222; transition: border 0.2s; }
        .field-value:focus { border: 1.2px solid #2563eb; }
        .back-btn { position: absolute; top: 18px; left: 18px; background: linear-gradient(90deg, #2563eb 0%, #10b981 100%); color: #fff; border: none; border-radius: 8px; padding: 10px 18px; font-size: 1rem; font-weight: 600; display: flex; align-items: center; gap: 8px; box-shadow: 0 2px 8px 0 rgba(37,99,235,0.10); cursor: pointer; transition: background 0.2s, box-shadow 0.2s; z-index: 10; }
        .back-btn .material-icons { font-size: 1.2em; }
        .back-btn:hover { background: linear-gradient(90deg, #10b981 0%, #2563eb 100%); box-shadow: 0 6px 18px 0 rgba(16,185,129,0.13); }
        @media (max-width: 700px) { .container { padding: 24px 4px 18px 4px; border-radius: 18px; } .logo-img { width: 130px; height: 91px; } .form-grid { grid-template-columns: 1fr; } .back-btn { top: 8px; left: 8px; padding: 8px 12px; font-size: 0.95rem; } }
    </style>
</head>
<body>
    <div style="position:absolute;top:18px;right:24px;z-index:100;">
        <a href="logout.php" style="background:linear-gradient(90deg,#e11d48 0%,#f87171 100%);color:#fff;padding:10px 22px;border-radius:8px;font-weight:600;text-decoration:none;box-shadow:0 2px 8px #e11d4811;display:flex;align-items:center;gap:8px;font-size:1.05em;">
            <span class="material-icons" style="font-size:1.2em;">logout</span> Sair
        </a>
    </div>
    <div class="container">
        <button onclick="window.location.href='index.php'" class="back-btn">
            <span class="material-icons">arrow_back</span> Voltar
        </button>
        <header class="header">
            <div class="menu-bar">
                <div class="logo-area">
                    <img src="chip.png" alt="Logo" class="logo-img" />
                </div>
            </div>
        </header>
        <div class="search-section">
            <div class="search-title">
                <h2>🔍 Consultar Cliente Boramvno</h2>
                <p>Digite o CPF ou CNPJ do cliente para consultar na base Boramvno</p>
            </div>
            <form class="search-form" id="searchForm">
                <div class="form-group" style="flex-direction: row; gap: 18px; align-items: center; margin-bottom: 8px;">
                    <label style="font-weight:600; color:#2563eb; display:flex; align-items:center; gap:4px;">
                        <input type="radio" name="searchType" id="searchCpf" value="cpf" checked style="accent-color:#2563eb; margin-right:4px;"> CPF/CNPJ
                    </label>
                    <label style="font-weight:600; color:#2563eb; display:flex; align-items:center; gap:4px;">
                        <input type="radio" name="searchType" id="searchPhone" value="phone" style="accent-color:#2563eb; margin-right:4px;"> Telefone
                    </label>
                </div>
                <div class="form-group">
                    <label class="form-label" id="mainInputLabel">CPF ou CNPJ</label>
                    <input type="text" class="form-input" id="documentInput" placeholder="Digite CPF ou CNPJ (máscara automática)" required>
                </div>
                <button type="submit" class="search-btn" id="searchBtn">
                    <span class="material-icons">search</span>
                    Consultar Cliente
                </button>
            </form>
        </div>
        <div class="loading" id="loading">
            <div class="spinner"></div>
            <p>Consultando dados do cliente...</p>
        </div>
        <div class="error-message" id="errorMessage"></div>
        <div class="success-message" id="successMessage"></div>
        <div class="results-section" id="resultsSection" style="display:none;">
            <h2 class="results-title">📊 Dados do Cliente Boramvno</h2>
            <div class="client-form">
                <form id="clientForm">
                    <div class="form-grid">
                        <div class="form-field">
                            <label class="field-label">🆔 ID</label>
                            <input class="field-value" id="clientId" name="clientId" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">👤 Nome</label>
                            <input class="field-value" id="clientName" name="clientName" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📄 CPF/CNPJ</label>
                            <input class="field-value" id="clientDocument" name="clientDocument" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📧 Email</label>
                            <input class="field-value" id="clientEmail" name="clientEmail" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📱 Telefone</label>
                            <input class="field-value" id="clientPhone" name="clientPhone" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🎂 Data de Nascimento</label>
                            <input class="field-value" id="clientBirthDate" name="clientBirthDate" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📍 Endereço</label>
                            <input class="field-value" id="clientAddress" name="clientAddress" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🔢 Número</label>
                            <input class="field-value" id="clientNumber" name="clientNumber" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🏘️ Bairro</label>
                            <input class="field-value" id="clientNeighborhood" name="clientNeighborhood" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🏙️ Cidade</label>
                            <input class="field-value" id="clientCity" name="clientCity" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🌍 Estado</label>
                            <input class="field-value" id="clientState" name="clientState" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📮 CEP</label>
                            <input class="field-value" id="clientZipCode" name="clientZipCode" type="text" value="-" />
                        </div>
                    </div>
                    <!-- Botão de atualizar removido -->
                </form>
            </div>
        </div>
        <!-- Seção de Ativação de nova linha -->
        <div class="results-section" style="margin-top:32px;">
            <h2 class="results-title">📲 Solicitar Portabilidade</h2>
            <form id="formPortabilidade" style="display:flex; flex-direction:column; gap:14px; align-items:stretch; max-width:400px; margin:0 auto;">
                <input type="text" id="nomePort" class="form-input" placeholder="Nome completo" required>
                <input type="text" id="documentoPort" class="form-input" placeholder="CPF ou CNPJ (somente números)" required>
                <input type="text" id="pmsisdnPort" class="form-input" placeholder="Número portado (ex: 5511981543020)" required>
                <input type="text" id="msisdnPort" class="form-input" placeholder="Novo número (ex: 5511896546785)" required>
                <input type="email" id="emailPort" class="form-input" placeholder="E-mail" required>
                <button type="button" class="search-btn" id="btnSolicitarPortabilidade" style="min-width:160px;">
                    <span class="material-icons">swap_horiz</span>
                    Solicitar Portabilidade
                </button>
            </form>
            <div id="resultadoPortabilidade" style="margin-top:18px;"></div>
        </div>
    </div>
    <script>
    // Máscara CPF/CNPJ igual ao cadastro.php
    function applyCPFMask(value) {
        return value.replace(/(\d{3})(\d)/, '$1.$2')
            .replace(/(\d{3})(\d)/, '$1.$2')
            .replace(/(\d{3})(\d{1,2})$/, '$1-$2');
    }
    function applyCNPJMask(value) {
        return value.replace(/(\d{2})(\d)/, '$1.$2')
            .replace(/(\d{3})(\d)/, '$1.$2')
            .replace(/(\d{3})(\d)/, '$1/$2')
            .replace(/(\d{4})(\d{1,2})$/, '$1-$2');
    }
    const documentInput = document.getElementById('documentInput');
    const searchCpf = document.getElementById('searchCpf');
    const searchPhone = document.getElementById('searchPhone');
    const mainInputLabel = document.getElementById('mainInputLabel');
    searchCpf.addEventListener('change', function() {
        if (searchCpf.checked) {
            mainInputLabel.textContent = 'CPF ou CNPJ';
            documentInput.value = '';
            documentInput.placeholder = 'Digite CPF ou CNPJ (máscara automática)';
            documentInput.maxLength = 18;
            documentInput.type = 'text';
        }
    });
    searchPhone.addEventListener('change', function() {
        if (searchPhone.checked) {
            mainInputLabel.textContent = 'Telefone (11 dígitos)';
            documentInput.value = '';
            documentInput.placeholder = 'Digite o número (ex: 75999006002)';
            documentInput.maxLength = 11;
            documentInput.type = 'tel';
        }
    });
    documentInput.addEventListener('input', function(e) {
        if (searchCpf.checked) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length <= 11) {
                e.target.value = applyCPFMask(value);
            } else if (value.length <= 14) {
                e.target.value = applyCNPJMask(value);
            } else {
                e.target.value = value;
            }
        } else {
            // Telefone: só números, máximo 11 dígitos
            e.target.value = e.target.value.replace(/\D/g, '').slice(0, 11);
        }
    });
    // Consulta Boramvno
    const searchForm = document.getElementById('searchForm');
    const loading = document.getElementById('loading');
    const errorMessage = document.getElementById('errorMessage');
    const successMessage = document.getElementById('successMessage');
    const resultsSection = document.getElementById('resultsSection');
    searchForm.addEventListener('submit', function(e) {
        e.preventDefault();
        errorMessage.style.display = 'none';
        successMessage.style.display = 'none';
        loading.style.display = 'flex';
        resultsSection.style.display = 'none';
        let url = '';
        let documentValue = documentInput.value.replace(/\D/g, '');
        if (searchCpf.checked) {
            url = 'consultar-subscriber.php?document=' + encodeURIComponent(documentValue);
        } else {
            // Telefone: adiciona 55 automaticamente
            if (documentValue.length !== 11) {
                loading.style.display = 'none';
                errorMessage.textContent = 'Digite um número de telefone válido com 11 dígitos.';
                errorMessage.style.display = 'block';
                return;
            }
            url = 'consultar-subscriber.php?msisdn=55' + encodeURIComponent(documentValue);
        }
        // Consulta principal
        fetch(url)
            .then(async response => {
                const text = await response.text();
                let data;
                try {
                    data = JSON.parse(text);
                } catch (e) {
                    if (text.includes('<form') && text.includes('login')) {
                        window.location.href = 'login.php';
                        return;
                    }
                    errorMessage.textContent = 'Sessão expirada ou erro inesperado. Faça login novamente.';
                    errorMessage.style.display = 'block';
                    loading.style.display = 'none';
                    return;
                }
                return data;
            })
            .then(data => {
                if (!data) return;
                loading.style.display = 'none';
                if (data.error || data.detail) {
                    errorMessage.textContent = 'Erro: ' + (data.detail || data.error);
                    errorMessage.style.display = 'block';
                    return;
                }
                // Preencher campos (mantém igual)
                const cliente = data;
                window.__ultimoClienteConsultado = cliente;
                document.getElementById('clientId').value = cliente.subscriberId || '-';
                document.getElementById('clientName').value = cliente.name || '-';
                document.getElementById('clientDocument').value = cliente.document || '-';
                document.getElementById('clientEmail').value = cliente.email || '-';
                document.getElementById('clientPhone').value = cliente.phone || cliente.msisdn || '-';
                document.getElementById('clientBirthDate').value = cliente.birthDate || '-';
                document.getElementById('clientAddress').value = cliente.street || '-';
                document.getElementById('clientNumber').value = cliente.number || '-';
                document.getElementById('clientNeighborhood').value = cliente.neighborhood || '-';
                document.getElementById('clientCity').value = cliente.city || '-';
                document.getElementById('clientState').value = cliente.uf || '-';
                document.getElementById('clientZipCode').value = cliente.zipcode || '-';
                // Preencher automaticamente o formulário de portabilidade
                if (document.getElementById('nomePort')) document.getElementById('nomePort').value = cliente.name || '';
                if (document.getElementById('documentoPort')) document.getElementById('documentoPort').value = (cliente.document || '').replace(/\D/g, '');
                if (document.getElementById('pmsisdnPort')) document.getElementById('pmsisdnPort').value = cliente.msisdn || '';
                if (document.getElementById('msisdnPort')) document.getElementById('msisdnPort').value = cliente.msisdn || '';
                if (document.getElementById('emailPort')) document.getElementById('emailPort').value = cliente.email || '';
                // Exibir campos extras se existirem
                let extraFields = '';
                if (cliente.msisdn) extraFields += `<div class='form-field'><label class='field-label'>MSISDN</label><input class='field-value' type='text' value='${cliente.msisdn}' readonly></div>`;
                if (cliente.plan) extraFields += `<div class='form-field'><label class='field-label'>Plano</label><input class='field-value' type='text' value='${cliente.plan}' readonly></div>`;
                if (typeof cliente.active !== 'undefined') extraFields += `<div class='form-field'><label class='field-label'>Ativo</label><input class='field-value' type='text' value='${cliente.active ? 'Sim' : 'Não'}' readonly></div>`;
                if (cliente.createdBy) extraFields += `<div class='form-field'><label class='field-label'>Criado por</label><input class='field-value' type='text' value='${cliente.createdBy.name} (${cliente.createdBy.email})' readonly></div>`;
                if (cliente.updatedBy) extraFields += `<div class='form-field'><label class='field-label'>Atualizado por</label><input class='field-value' type='text' value='${cliente.updatedBy.name} (${cliente.updatedBy.email})' readonly></div>`;
                if (cliente.updateDate) extraFields += `<div class='form-field'><label class='field-label'>Data Atualização</label><input class='field-value' type='text' value='${cliente.updateDate}' readonly></div>`;
                if (cliente.creationDate) extraFields += `<div class='form-field'><label class='field-label'>Data Criação</label><input class='field-value' type='text' value='${cliente.creationDate}' readonly></div>`;
                if (cliente.idSubscriberExternal) extraFields += `<div class='form-field'><label class="field-label">ID Externo</label><input class='field-value' type='text' value='${cliente.idSubscriberExternal}' readonly></div>`;
                // Adiciona campos extras ao final do form
                const formGrid = document.querySelector('.form-grid');
                if (formGrid && extraFields) {
                  formGrid.insertAdjacentHTML('beforeend', extraFields);
                }
                resultsSection.style.display = 'block';
                // NOVO: Consulta de portabilidade
                const portabilidadeDiv = document.getElementById('portabilidadeDisponivelDiv') || (function(){
                    const d = document.createElement('div');
                    d.id = 'portabilidadeDisponivelDiv';
                    d.style.marginTop = '32px';
                    document.querySelector('.container').appendChild(d);
                    return d;
                })();
                portabilidadeDiv.innerHTML = '<div style="background:#f1f5f9;padding:18px 14px;border-radius:12px;max-width:420px;margin:0 auto 18px auto;"><span class="material-icons" style="color:#2563eb;vertical-align:middle;">hourglass_top</span> Consultando número disponível para portabilidade...</div>';
                fetch('proxy-chip.php?rota=' + encodeURIComponent('/api/Portability/' + documentValue + '/document'))
                    .then(resp => resp.json())
                    .then(portData => {
                        if (portData.error || portData.detail) {
                            portabilidadeDiv.innerHTML = `<div style='background:#fee2e2;padding:18px 14px;border-radius:12px;max-width:420px;margin:0 auto 18px auto;'><span class='material-icons' style='color:#e11d48;vertical-align:middle;'>error</span> Erro: ${portData.detail || portData.error}</div>`;
                        } else {
                            // Ajuste: resposta é um array de objetos
                            let msisdnElegante = '';
                            if (Array.isArray(portData) && portData.length > 0) {
                                msisdnElegante = portData[0].msisdn || portData[0].MSISDN || portData[0].numero || '';
                            } else if (portData.msisdn || portData.MSISDN || portData.numero) {
                                msisdnElegante = portData.msisdn || portData.MSISDN || portData.numero;
                            }
                            let html = `<div style='background:#d1fae5;border:2px solid #10b981;padding:18px 14px;border-radius:12px;max-width:420px;margin:0 auto 18px auto;display:flex;align-items:center;gap:12px;'>`;
                            html += `<span class='material-icons' style='color:#10b981;font-size:2.2em;'>sim_card</span>`;
                            html += `<div><div style='font-size:1.1em;font-weight:700;color:#065f46;margin-bottom:2px;'>Número disponível para ser portado</div>`;
                            html += `<div style='font-size:1.25em;color:#2563eb;font-weight:600;'>${msisdnElegante ? msisdnElegante : 'Não informado'}</div></div></div>`;
                            portabilidadeDiv.innerHTML = html;
                            // Preencher automaticamente o campo 'Novo número' (msisdn) do formulário
                            if (msisdnElegante && document.getElementById('msisdnPort')) {
                                document.getElementById('msisdnPort').value = msisdnElegante;
                            }
                        }
                    })
                    .catch(err => {
                        portabilidadeDiv.innerHTML = `<div style='background:#fee2e2;padding:18px 14px;border-radius:12px;max-width:420px;margin:0 auto 18px auto;'><span class='material-icons' style='color:#e11d48;vertical-align:middle;'>error</span> Erro ao consultar portabilidade: ${err.message}</div>`;
                    });
            })
            .catch(err => {
                loading.style.display = 'none';
                errorMessage.textContent = 'Erro ao consultar cliente: ' + err.message;
                errorMessage.style.display = 'block';
            });
    });
    document.getElementById('btnSolicitarPortabilidade').addEventListener('click', function() {
        const nome = document.getElementById('nomePort').value.trim();
        const documento = document.getElementById('documentoPort').value.replace(/\D/g, '');
        const pmsisdn = document.getElementById('pmsisdnPort').value.replace(/\D/g, '');
        const msisdn = document.getElementById('msisdnPort').value.replace(/\D/g, '');
        const email = document.getElementById('emailPort').value.trim();
        const resultado = document.getElementById('resultadoPortabilidade');
        resultado.innerHTML = '';
        if (!nome || !documento || !pmsisdn || !msisdn || !email) {
            resultado.innerHTML = '<span style="color:#e11d48;">Preencha todos os campos.</span>';
            return;
        }
        document.getElementById('btnSolicitarPortabilidade').disabled = true;
        document.getElementById('btnSolicitarPortabilidade').innerHTML = '<span class="material-icons">hourglass_top</span>Enviando...';
        const payload = {
            name: nome,
            document: documento,
            pmsisdn: pmsisdn,
            msisdn: msisdn,
            email: email
        };
        fetch('proxy-chip.php?rota=' + encodeURIComponent('/api/Portability'), {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(payload)
        })
        .then(resp => resp.text())
        .then(text => {
            let data;
            try {
                data = text ? JSON.parse(text) : { success: true, message: 'Portabilidade solicitada com sucesso!' };
            } catch (e) {
                data = { success: true, message: 'Portabilidade solicitada com sucesso!' };
            }
            document.getElementById('btnSolicitarPortabilidade').disabled = false;
            document.getElementById('btnSolicitarPortabilidade').innerHTML = '<span class="material-icons">swap_horiz</span>Solicitar Portabilidade';
            if (data.error || data.detail) {
                resultado.innerHTML = `<span style='color:#e11d48;'>Erro: ${data.detail || data.error}</span>`;
            } else {
                resultado.innerHTML = `<div style='background:#d1fae5;border:2px solid #10b981;padding:18px 14px;border-radius:12px;box-shadow:0 2px 12px #10b98122;display:flex;flex-direction:column;align-items:center;gap:8px;max-width:420px;margin:0 auto;'>
                    <span class="material-icons" style="color:#10b981;font-size:3em;">check_circle</span>
                    <div style="font-size:1.1em;font-weight:600;color:#065f46;">Portabilidade solicitada com sucesso!</div>
                    <div style='font-size:1.05em;color:#2563eb;margin-top:8px;'>${data.message ? data.message : ''}</div>
                </div>`;
            }
        })
        .catch(err => {
            document.getElementById('btnSolicitarPortabilidade').disabled = false;
            document.getElementById('btnSolicitarPortabilidade').innerHTML = '<span class="material-icons">swap_horiz</span>Solicitar Portabilidade';
            resultado.innerHTML = `<span style='color:#e11d48;'>Erro ao solicitar portabilidade: ${err.message}</span>`;
        });
    });
    </script>
</body>
</html>
