<?php
session_start();
$erro = '';
if (isset($_POST['email']) && isset($_POST['password'])) {
    $email = $_POST['email'];
    $password = $_POST['password'];
    $baseUrl = 'https://app.boramvno.com.br/appapi';
    $auth = base64_encode("$email:$password");
    $ch = curl_init($baseUrl . '/api/Authentication/basic');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Basic $auth",
        "Content-Type: application/json"
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, '{}');
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
    $response = curl_exec($ch);
    $headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $header = substr($response, 0, $headerSize);
    $body   = substr($response, $headerSize);
    curl_close($ch);
    $authResult = json_decode($body, true);
    $token = null;
    if (isset($authResult['token'])) {
        $token = $authResult['token'];
    } else if (preg_match('/x-access-token:\s*(.+)/i', $header, $matches)) {
        $token = trim($matches[1]);
    }
    if ($token) {
        $_SESSION['bora_email'] = $email;
        $_SESSION['bora_password'] = $password;
        header('Location: index.php');
        exit;
    } else {
        $erro = 'Usuário ou senha incorretos.';
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Core3Chip</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <style>
        body { min-height: 100vh; background: linear-gradient(135deg, #0f2027 0%, #2c5364 100%); display: flex; align-items: center; justify-content: center; font-family: 'Inter', sans-serif; margin: 0; }
        .login-container { background: #fff; border-radius: 24px; box-shadow: 0 8px 40px 0 rgba(37,99,235,0.18); padding: 48px 36px; max-width: 350px; width: 100%; display: flex; flex-direction: column; align-items: center; gap: 28px; }
        .logo-img { width: 120px; height: 80px; object-fit: contain; margin-bottom: 8px; }
        .login-title { font-size: 1.3rem; font-weight: 700; color: #2563eb; margin-bottom: 8px; }
        .login-form { width: 100%; display: flex; flex-direction: column; gap: 18px; }
        .form-group { display: flex; flex-direction: column; gap: 6px; }
        .form-label { font-size: 1rem; color: #1e293b; font-weight: 600; }
        .form-input { padding: 12px 14px; border-radius: 8px; border: 1.5px solid #cbd5e1; font-size: 1.08rem; outline: none; transition: border 0.2s; }
        .form-input:focus { border: 1.5px solid #2563eb; }
        .login-btn { padding: 13px 0; border: none; border-radius: 10px; font-size: 1.08rem; font-weight: 600; color: #fff; background: linear-gradient(90deg, #2563eb 0%, #10b981 100%); box-shadow: 0 2px 12px 0 rgba(37,99,235,0.10); cursor: pointer; display: flex; align-items: center; justify-content: center; gap: 10px; transition: background 0.2s, transform 0.2s, box-shadow 0.2s; outline: none; letter-spacing: 0.5px; }
        .login-btn .material-icons { font-size: 1.3em; vertical-align: middle; }
        .login-btn:hover { background: linear-gradient(90deg, #10b981 0%, #2563eb 100%); transform: translateY(-2px) scale(1.03); box-shadow: 0 6px 24px 0 rgba(16,185,129,0.13); }
        .error-message { background: #fee2e2; color: #b91c1c; border: 1.5px solid #f87171; border-radius: 8px; padding: 10px 18px; font-size: 1.02rem; font-weight: 500; margin-bottom: 8px; text-align: center; }
    </style>
</head>
<body>
    <div class="login-container">
        <img src="chip.png" alt="Logo" class="logo-img" />
        <div class="login-title">Acesso ao Sistema</div>
        <?php if ($erro): ?>
            <div class="error-message"><span class="material-icons" style="vertical-align:middle;">error</span> <?php echo htmlspecialchars($erro); ?></div>
        <?php endif; ?>
        <form class="login-form" method="post" autocomplete="off">
            <div class="form-group">
                <label class="form-label" for="email">E-mail</label>
                <input class="form-input" type="email" id="email" name="email" required autofocus />
            </div>
            <div class="form-group">
                <label class="form-label" for="password">Senha</label>
                <input class="form-input" type="password" id="password" name="password" required />
            </div>
            <button class="login-btn" type="submit"><span class="material-icons">login</span> Entrar</button>
        </form>
    </div>
</body>
</html>
