#!/bin/bash

echo "🚀 INSTALAÇÃO DO SISTEMA CORE3CHIP"
echo "=================================="

# 1. Atualizar sistema
echo "📦 Atualizando repositórios..."
apt-get update

# 2. Instalar extensões PHP necessárias
echo "🔧 Instalando extensões PHP..."
apt-get install -y php7.4-curl php7.4-xml php7.4-mbstring php7.4-mysql php7.4-json

# 3. Criar diretório do sistema
echo "📁 Criando diretório do sistema..."
mkdir -p /var/www/html/sistema
chown -R www-data:www-data /var/www/html/sistema
chmod -R 755 /var/www/html/sistema

# 4. Criar diretório de logs
echo "📝 Criando diretório de logs..."
mkdir -p /var/www/html/sistema/logs
chmod -R 777 /var/www/html/sistema/logs

# 5. Verificar extensões PHP
echo "✅ Verificando extensões PHP instaladas..."
php -m | grep -E "(curl|xml|mbstring|mysql|json)"

# 6. Verificar serviços
echo "🔍 Verificando status dos serviços..."
systemctl status apache2 --no-pager
systemctl status mysql --no-pager

# 7. Criar banco de dados
echo "🗄️ Configurando banco de dados..."
mysql -e "CREATE DATABASE IF NOT EXISTS ixcprovedor;"
mysql -e "USE ixcprovedor; SHOW TABLES;"

echo ""
echo "✅ INSTALAÇÃO CONCLUÍDA!"
echo "📁 Sistema será instalado em: /var/www/html/sistema"
echo "📝 Logs em: /var/www/html/sistema/logs"
echo "🌐 Acesse: http://192.168.2.16/sistema"
echo ""
echo "📋 PRÓXIMOS PASSOS:"
echo "1. Upload dos arquivos do sistema"
echo "2. Configurar permissões"
echo "3. Configurar cron automático"
echo "4. Testar sistema"

