<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Core3Chip - Sistema Telecom</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
  <style>
    body {
      min-height: 100vh;
      background: linear-gradient(135deg, #0f2027 0%, #2c5364 100%);
      display: flex;
      align-items: center;
      justify-content: center;
      font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
      margin: 0;
    }
    .main-container {
      background: rgba(255,255,255,0.97);
      border-radius: 32px;
      box-shadow: 0 8px 40px 0 rgba(37,99,235,0.18), 0 1.5px 8px 0 rgba(16,185,129,0.10);
      padding: 56px 40px 48px 40px;
      max-width: 420px;
      width: 100%;
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 36px;
      position: relative;
    }
    .logo {
      width: 180px;
      height: 110px;
      object-fit: contain;
      object-position: center;
      margin-bottom: 12px;
      filter: drop-shadow(0 4px 24px #2563eb33);
      background: transparent;
      border-radius: 18px;
    }
    .title {
      font-size: 2.1rem;
      font-weight: 700;
      color: #1d3557;
      letter-spacing: 1px;
      text-align: center;
      margin-bottom: 0.5em;
      background: linear-gradient(90deg, #2563eb, #10b981, #f59e0b);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
    }
    .btn-group {
      display: flex;
      flex-direction: column;
      gap: 22px;
      width: 100%;
      margin-top: 10px;
    }
    .md-btn {
      width: 100%;
      padding: 18px 0;
      border: none;
      border-radius: 14px;
      font-size: 1.15rem;
      font-weight: 600;
      color: #fff;
      background: linear-gradient(90deg, #2563eb 0%, #10b981 100%);
      box-shadow: 0 2px 12px 0 rgba(37,99,235,0.10);
      cursor: pointer;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 14px;
      transition: background 0.2s, transform 0.2s, box-shadow 0.2s;
      outline: none;
      letter-spacing: 0.5px;
    }
    .md-btn .material-icons {
      font-size: 1.5em;
      vertical-align: middle;
    }
    .md-btn:hover {
      background: linear-gradient(90deg, #10b981 0%, #2563eb 100%);
      transform: translateY(-2px) scale(1.03);
      box-shadow: 0 6px 24px 0 rgba(16,185,129,0.13);
    }
    @media (max-width: 600px) {
      .main-container {
        padding: 32px 8px 28px 8px;
        border-radius: 18px;
      }
      .logo {
        width: 120px;
        height: 70px;
      }
      .title {
        font-size: 1.3rem;
      }
    }
  </style>
</head>
<body>
  <div style="position:absolute;top:18px;right:24px;z-index:100;">
    <a href="logout.php" style="background:linear-gradient(90deg,#e11d48 0%,#f87171 100%);color:#fff;padding:10px 22px;border-radius:8px;font-weight:600;text-decoration:none;box-shadow:0 2px 8px #e11d4811;display:flex;align-items:center;gap:8px;font-size:1.05em;">
        <span class="material-icons" style="font-size:1.2em;">logout</span> Sair
    </a>
</div>
  <div class="main-container">
    <img src="chip.png" alt="Logo Core3Chip" class="logo" />
    <div class="title">Core3Chip<br>Sistema de Telecom</div>
    <div class="btn-group">
      <button class="md-btn" onclick="window.location.href='cadastro.php'">
        <span class="material-icons">person_add</span> Cadastro
      </button>
      <button class="md-btn" onclick="window.location.href='portabilidade.php'">
        <span class="material-icons">swap_horiz</span> Solicitar Portabilidade
      </button>
      <button class="md-btn" onclick="window.location.href='consultar-cliente.php'">
        <span class="material-icons">search</span> Consultar Cliente
      </button>
      <button class="md-btn" onclick="window.location.href='andamento.php'">
        <span class="material-icons">dvr</span> Consultar portabilidades em andamento
      </button>
      <button class="md-btn" onclick="window.location.href='linhas.php'">
          <span class="material-icons">settings_input_antenna</span>
          Ativar linhas
      </button>
      <button class="md-btn" onclick="window.location.href='consumos.php'">
          <span class="material-icons">data_usage</span>
          Consultar linhas
      </button>
      <button class="md-btn" onclick="window.location.href='consultar-planos.php'">
          <span class="material-icons">list_alt</span>
          Consultar Planos
      </button>
    </div>
  </div>
</body>
</html>
