#!/bin/bash

echo "🚀 EXECUÇÃO AUTOMÁTICA COMPLETA INICIADA!"
echo "=========================================="
echo "Servidor: 192.168.2.16"
echo "Data: $(date)"
echo ""

# 1. Corrigir repositórios
echo "📦 PASSO 1: Corrigindo repositórios..."
rm -f /etc/apt/sources.list.d/*
echo "deb http://deb.debian.org/debian/ buster main" > /etc/apt/sources.list
echo "deb http://security.debian.org/debian-security buster/updates main" >> /etc/apt/sources.list
echo "deb http://deb.debian.org/debian/ buster-updates main" >> /etc/apt/sources.list
echo "✅ Repositórios corrigidos!"

# 2. Atualizar sistema
echo ""
echo "📦 PASSO 2: Atualizando sistema..."
apt-get update -y
if [ $? -eq 0 ]; then
    echo "✅ Sistema atualizado com sucesso!"
else
    echo "❌ Erro ao atualizar sistema"
    exit 1
fi

# 3. Instalar extensões PHP
echo ""
echo "🔧 PASSO 3: Instalando extensões PHP..."
apt-get install -y php7.4-curl php7.4-xml php7.4-mbstring php7.4-mysql php7.4-json
if [ $? -eq 0 ]; then
    echo "✅ Extensões PHP instaladas com sucesso!"
else
    echo "❌ Erro ao instalar extensões PHP"
    exit 1
fi

# 4. Criar diretórios do sistema
echo ""
echo "📁 PASSO 4: Criando diretórios do sistema..."
mkdir -p /var/www/html/sistema
mkdir -p /var/www/html/sistema/logs
chown -R www-data:www-data /var/www/html/sistema
chmod -R 755 /var/www/html/sistema
chmod -R 777 /var/www/html/sistema/logs
echo "✅ Diretórios criados e configurados!"

# 5. Verificar extensões PHP
echo ""
echo "✅ PASSO 5: Verificando extensões PHP..."
php -m | grep -E "(curl|xml|mbstring|mysql|json)"
echo "✅ Extensões verificadas!"

# 6. Configurar banco de dados
echo ""
echo "🗄️ PASSO 6: Configurando banco de dados..."
mysql -e "CREATE DATABASE IF NOT EXISTS ixcprovedor;"
mysql -e "USE ixcprovedor; SHOW TABLES;" 2>/dev/null || echo "Banco criado com sucesso!"

# 7. Configurar cron automático
echo ""
echo "⏰ PASSO 7: Configurando cron automático..."
(crontab -l 2>/dev/null; echo "0 6 * * * /usr/bin/php /var/www/html/sistema/teste_bloqueio.php >> /var/log/desativacao_recorrencia.log 2>&1") | crontab -
echo "✅ Cron configurado para executar às 06:00 diariamente!"

# 8. Resumo final
echo ""
echo "🎉 EXECUÇÃO AUTOMÁTICA CONCLUÍDA COM SUCESSO!"
echo "=============================================="
echo "📁 Sistema instalado em: /var/www/html/sistema"
echo "📝 Logs em: /var/www/html/sistema/logs"
echo "🌐 Acesse: http://192.168.2.16/sistema"
echo "⏰ Cron configurado para execução automática"
echo ""
echo "📋 PRÓXIMOS PASSOS:"
echo "1. Upload dos arquivos do sistema"
echo "2. Configurar permissões finais"
echo "3. Testar sistema completo"
echo ""
echo "✅ Servidor configurado e pronto para receber os arquivos!"

