#!/bin/bash

echo "🚀 DEPLOY COMPLETO - Sistema Core3Chip"
echo "======================================"
echo "🌐 Servidor: 192.168.2.16:60111"
echo "📁 Destino: /var/www/sistema"
echo ""

# Verificar se estamos no diretório correto
if [ ! -f "config.php" ] || [ ! -f "login.php" ]; then
    echo "❌ ERRO: Execute este script no diretório do sistema!"
    echo "📁 Diretório atual: $(pwd)"
    echo "📋 Arquivos esperados: config.php, login.php"
    exit 1
fi

echo "✅ Diretório correto detectado!"
echo ""

# Tornar scripts executáveis
chmod +x configurar_servidor_remoto.sh
chmod +x upload_para_servidor.sh
chmod +x configurar_cron_remoto.sh

echo "📋 FASE 1: Configuração do servidor remoto..."
echo "----------------------------------------------"
read -p "🤔 Deseja configurar o servidor remoto? (y/n): " -n 1 -r
echo ""

if [[ $REPLY =~ ^[Yy]$ ]]; then
    echo "🔧 Executando configuração do servidor..."
    ssh -p 60111 root@192.168.2.16 "bash -s" < configurar_servidor_remoto.sh
    
    if [ $? -eq 0 ]; then
        echo "✅ Servidor configurado com sucesso!"
    else
        echo "❌ Erro na configuração do servidor!"
        exit 1
    fi
else
    echo "⏭️ Pulando configuração do servidor..."
fi

echo ""
echo "📋 FASE 2: Upload dos arquivos..."
echo "----------------------------------"
read -p "🤔 Deseja fazer upload dos arquivos? (y/n): " -n 1 -r
echo ""

if [[ $REPLY =~ ^[Yy]$ ]]; then
    echo "📤 Executando upload..."
    ./upload_para_servidor.sh
    
    if [ $? -eq 0 ]; then
        echo "✅ Upload concluído com sucesso!"
    else
        echo "❌ Erro no upload!"
        exit 1
    fi
else
    echo "⏭️ Pulando upload..."
fi

echo ""
echo "📋 FASE 3: Configuração do cron job..."
echo "---------------------------------------"
read -p "🤔 Deseja configurar o cron job? (y/n): " -n 1 -r
echo ""

if [[ $REPLY =~ ^[Yy]$ ]]; then
    echo "⏰ Configurando cron job..."
    ./configurar_cron_remoto.sh
    
    if [ $? -eq 0 ]; then
        echo "✅ Cron job configurado com sucesso!"
    else
        echo "❌ Erro na configuração do cron!"
        exit 1
    fi
else
    echo "⏭️ Pulando configuração do cron..."
fi

echo ""
echo "📋 FASE 4: Teste final..."
echo "--------------------------"
read -p "🤔 Deseja testar o sistema? (y/n): " -n 1 -r
echo ""

if [[ $REPLY =~ ^[Yy]$ ]]; then
    echo "🧪 Testando sistema..."
    
    # Testar se o sistema está respondendo
    echo "🔍 Testando resposta HTTP..."
    HTTP_RESPONSE=$(curl -s -o /dev/null -w "%{http_code}" "http://192.168.2.16/sistema/")
    
    if [ "$HTTP_RESPONSE" = "200" ]; then
        echo "✅ Sistema respondendo (HTTP 200)"
    else
        echo "⚠️ Sistema retornou HTTP $HTTP_RESPONSE"
    fi
    
    # Testar configuração PHP
    echo "🔍 Testando configuração PHP..."
    ssh -p 60111 root@192.168.2.16 "cd /var/www/sistema && php -f config.php"
    
else
    echo "⏭️ Pulando teste..."
fi

echo ""
echo "======================================"
echo "🎉 DEPLOY COMPLETO FINALIZADO!"
echo "======================================"
echo "🌐 URL do Sistema: http://192.168.2.16/sistema"
echo "📁 Diretório: /var/www/sistema"
echo "📝 Logs: /var/www/sistema/logs"
echo "⏰ Cron: A cada 5 minutos"
echo ""
echo "📋 Próximos passos:"
echo "1. Acesse http://192.168.2.16/sistema"
echo "2. Teste o login e funcionalidades"
echo "3. Verifique os logs em /var/www/sistema/logs"
echo "4. Monitore o cron job"
echo ""
echo "🔧 Comandos úteis:"
echo "ssh -p 60111 root@192.168.2.16"
echo "tail -f /var/www/sistema/logs/cron.log"
echo "systemctl status apache2"
echo "======================================"
