<?php
// Debug simples da consulta IXC (sem grid_param)
require_once 'confApi.php';

echo "<h2>🔍 Debug Simples da Consulta IXC</h2>";

try {
    // CPF de teste
    $cpf_teste = '04435315521';
    
    echo "<p><strong>CPF Original:</strong> $cpf_teste</p>";
    
    // Aplicar máscara
    $query = preg_replace("/(\d{3})(\d{3})(\d{3})(\d{2})/", "$1.$2.$3-$4", $cpf_teste);
    echo "<p><strong>CPF com Máscara:</strong> $query</p>";
    
    // Teste 1: SEM grid_param (como estava antes)
    echo "<h3>🧪 Teste 1: SEM grid_param</h3>";
    $params1 = array(
        'qtype' => 'cliente.cnpj_cpf',
        'query' => $query,
        'oper' => '=',
        'page' => '1',
        'rp' => '20',
        'sortname' => 'cliente.id',
        'sortorder' => 'desc'
    );
    
    $api->get('cliente', $params1);
    $retorno1 = $api->getRespostaConteudo(false);
    $data1 = json_decode($retorno1, true);
    
    echo "<p><strong>Registros encontrados:</strong> " . (isset($data1['rows']) ? count($data1['rows']) : 'N/A') . "</p>";
    
    // Teste 2: COM grid_param (como no consulta.php)
    echo "<h3>🧪 Teste 2: COM grid_param</h3>";
    $params2 = array(
        'qtype' => 'cliente.cnpj_cpf',
        'query' => $query,
        'oper' => '=',
        'page' => '1',
        'rp' => '20',
        'sortname' => 'cliente.id',
        'sortorder' => 'desc',
        'grid_param' => json_encode([
            ['TB' => 'cliente.ativo', 'OP' => '=', 'P' => 'S']
        ])
    );
    
    $api->get('cliente', $params2);
    $retorno2 = $api->getRespostaConteudo(false);
    $data2 = json_decode($retorno2, true);
    
    echo "<p><strong>Registros encontrados:</strong> " . (isset($data2['rows']) ? count($data2['rows']) : 'N/A') . "</p>";
    
    // Teste 3: Exatamente como no consulta.php
    echo "<h3>🧪 Teste 3: Exatamente como no consulta.php</h3>";
    $id_cliente = $cpf_teste;
    $qtype = 'cliente.cnpj_cpf';
    $query3 = $id_cliente;
    if (ctype_digit($id_cliente) && strlen($id_cliente) === 11) {
        $query3 = preg_replace("/(\d{3})(\d{3})(\d{3})(\d{2})/", "$1.$2.$3-$4", $id_cliente);
    }
    
    $params3 = array(
        'qtype' => $qtype,
        'query' => "$query3",
        'oper' => '=',
        'page' => '1',
        'rp' => '20',
        'sortname' => 'cliente.id',
        'sortorder' => 'desc',
        'grid_param' => json_encode([
            ['TB' => 'cliente.ativo', 'OP' => '=', 'P' => 'S']
        ])
    );
    
    $api->get('cliente', $params3);
    $retorno3 = $api->getRespostaConteudo(false);
    $data3 = json_decode($retorno3, true);
    
    echo "<p><strong>Registros encontrados:</strong> " . (isset($data3['rows']) ? count($data3['rows']) : 'N/A') . "</p>";
    
    // Comparar resultados
    echo "<h3>📊 Comparação dos Resultados</h3>";
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr style='background-color: #f0f0f0;'>";
    echo "<th>Teste</th>";
    echo "<th>Registros</th>";
    echo "<th>Status</th>";
    echo "</tr>";
    
    $testes = [
        'Sem grid_param' => $data1,
        'Com grid_param' => $data2,
        'Como consulta.php' => $data3
    ];
    
    foreach ($testes as $nome => $data) {
        $registros = isset($data['rows']) ? count($data['rows']) : 0;
        $status = $registros > 0 ? '✅ Encontrado' : '❌ Não encontrado';
        echo "<tr>";
        echo "<td>$nome</td>";
        echo "<td>$registros</td>";
        echo "<td>$status</td>";
        echo "</tr>";
    }
    echo "</table>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Erro: " . $e->getMessage() . "</p>";
}
?>
