import type { Metadata } from 'next'
import { Inter } from 'next/font/google'
import './globals.css'

const inter = Inter({ subsets: ['latin'] })

export const metadata: Metadata = {
  title: 'CuidaMais.vc - Plataforma de Cuidados de Saúde',
  description: 'Conectamos você aos melhores profissionais de saúde. Agende consultas, encontre especialistas e cuide da sua saúde de forma simples e segura.',
}

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="pt-BR">
      <body className={inter.className}>{children}</body>
    </html>
  )
} 