'use client'

import { useState } from 'react'
import { Button } from '@/components/ui/button'
import { Input } from '@/components/ui/input'
import { Label } from '@/components/ui/label'
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card'
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from '@/components/ui/select'
import { Heart, ArrowLeft, CheckCircle, Shield, Clock, Users, Star } from 'lucide-react'
import Link from 'next/link'

export default function CadastroPage() {
  const [formData, setFormData] = useState({
    nome: '',
    sobrenome: '',
    cpf: '',
    dataNascimento: '',
    email: '',
    telefone: '',
    cep: '',
    endereco: '',
    numero: '',
    complemento: '',
    bairro: '',
    cidade: '',
    estado: '',
    plano: '',
    aceiteTermos: false
  })

  const handleInputChange = (e: React.ChangeEvent<HTMLInputElement>) => {
    const { name, value, type, checked } = e.target
    setFormData(prev => ({
      ...prev,
      [name]: type === 'checkbox' ? checked : value
    }))
  }

  const handleSelectChange = (name: string, value: string) => {
    setFormData(prev => ({
      ...prev,
      [name]: value
    }))
  }

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault()
    console.log('Dados do formulário:', formData)
    // Aqui você pode adicionar a lógica para enviar os dados
    alert('Cadastro realizado com sucesso! Em breve entraremos em contato.')
  }

  return (
    <div className="min-h-screen bg-gradient-to-br from-blue-50 to-indigo-100">
      {/* Header */}
      <header className="bg-white shadow-sm">
        <div className="container mx-auto px-4 py-4">
          <div className="flex items-center justify-between">
            <Link href="/" className="flex items-center space-x-2">
              <ArrowLeft className="h-5 w-5 text-blue-600" />
              <span className="text-gray-600">Voltar</span>
            </Link>
            <div className="flex items-center space-x-2">
              <Heart className="h-8 w-8 text-blue-600" />
              <span className="text-2xl font-bold text-gray-900">CuidaMais.vc</span>
            </div>
            <div className="w-20"></div> {/* Espaçador */}
          </div>
        </div>
      </header>

      <div className="container mx-auto px-4 py-8">
        <div className="grid lg:grid-cols-2 gap-8 max-w-6xl mx-auto">
          {/* Coluna do Formulário */}
          <div>
            <Card className="shadow-lg">
              <CardHeader className="text-center">
                <CardTitle className="text-3xl font-bold text-gray-900">
                  Cadastre-se no CuidaMais.vc
                </CardTitle>
                <CardDescription className="text-lg">
                  Preencha seus dados e comece a cuidar da sua saúde hoje mesmo
                </CardDescription>
              </CardHeader>
              <CardContent className="p-6">
                <form onSubmit={handleSubmit} className="space-y-6">
                  {/* Dados Pessoais */}
                  <div className="space-y-4">
                    <h3 className="text-lg font-semibold text-gray-900 border-b pb-2">
                      Dados Pessoais
                    </h3>
                    
                    <div className="grid md:grid-cols-2 gap-4">
                      <div>
                        <Label htmlFor="nome">Nome *</Label>
                        <Input
                          id="nome"
                          name="nome"
                          value={formData.nome}
                          onChange={handleInputChange}
                          required
                          placeholder="Seu nome"
                        />
                      </div>
                      <div>
                        <Label htmlFor="sobrenome">Sobrenome *</Label>
                        <Input
                          id="sobrenome"
                          name="sobrenome"
                          value={formData.sobrenome}
                          onChange={handleInputChange}
                          required
                          placeholder="Seu sobrenome"
                        />
                      </div>
                    </div>

                    <div className="grid md:grid-cols-2 gap-4">
                      <div>
                        <Label htmlFor="cpf">CPF *</Label>
                        <Input
                          id="cpf"
                          name="cpf"
                          value={formData.cpf}
                          onChange={handleInputChange}
                          required
                          placeholder="000.000.000-00"
                        />
                      </div>
                      <div>
                        <Label htmlFor="dataNascimento">Data de Nascimento *</Label>
                        <Input
                          id="dataNascimento"
                          name="dataNascimento"
                          type="date"
                          value={formData.dataNascimento}
                          onChange={handleInputChange}
                          required
                        />
                      </div>
                    </div>

                    <div className="grid md:grid-cols-2 gap-4">
                      <div>
                        <Label htmlFor="email">E-mail *</Label>
                        <Input
                          id="email"
                          name="email"
                          type="email"
                          value={formData.email}
                          onChange={handleInputChange}
                          required
                          placeholder="seu@email.com"
                        />
                      </div>
                      <div>
                        <Label htmlFor="telefone">Telefone *</Label>
                        <Input
                          id="telefone"
                          name="telefone"
                          value={formData.telefone}
                          onChange={handleInputChange}
                          required
                          placeholder="(11) 99999-9999"
                        />
                      </div>
                    </div>
                  </div>

                  {/* Endereço */}
                  <div className="space-y-4">
                    <h3 className="text-lg font-semibold text-gray-900 border-b pb-2">
                      Endereço
                    </h3>
                    
                    <div className="grid md:grid-cols-2 gap-4">
                      <div>
                        <Label htmlFor="cep">CEP *</Label>
                        <Input
                          id="cep"
                          name="cep"
                          value={formData.cep}
                          onChange={handleInputChange}
                          required
                          placeholder="00000-000"
                        />
                      </div>
                      <div>
                        <Label htmlFor="endereco">Endereço *</Label>
                        <Input
                          id="endereco"
                          name="endereco"
                          value={formData.endereco}
                          onChange={handleInputChange}
                          required
                          placeholder="Rua, Avenida, etc."
                        />
                      </div>
                    </div>

                    <div className="grid md:grid-cols-3 gap-4">
                      <div>
                        <Label htmlFor="numero">Número *</Label>
                        <Input
                          id="numero"
                          name="numero"
                          value={formData.numero}
                          onChange={handleInputChange}
                          required
                          placeholder="123"
                        />
                      </div>
                      <div>
                        <Label htmlFor="complemento">Complemento</Label>
                        <Input
                          id="complemento"
                          name="complemento"
                          value={formData.complemento}
                          onChange={handleInputChange}
                          placeholder="Apto, Casa, etc."
                        />
                      </div>
                      <div>
                        <Label htmlFor="bairro">Bairro *</Label>
                        <Input
                          id="bairro"
                          name="bairro"
                          value={formData.bairro}
                          onChange={handleInputChange}
                          required
                          placeholder="Seu bairro"
                        />
                      </div>
                    </div>

                    <div className="grid md:grid-cols-2 gap-4">
                      <div>
                        <Label htmlFor="cidade">Cidade *</Label>
                        <Input
                          id="cidade"
                          name="cidade"
                          value={formData.cidade}
                          onChange={handleInputChange}
                          required
                          placeholder="Sua cidade"
                        />
                      </div>
                      <div>
                        <Label htmlFor="estado">Estado *</Label>
                        <Select value={formData.estado} onValueChange={(value) => handleSelectChange('estado', value)}>
                          <SelectTrigger>
                            <SelectValue placeholder="Selecione o estado" />
                          </SelectTrigger>
                          <SelectContent>
                            <SelectItem value="SP">São Paulo</SelectItem>
                            <SelectItem value="RJ">Rio de Janeiro</SelectItem>
                            <SelectItem value="MG">Minas Gerais</SelectItem>
                            <SelectItem value="RS">Rio Grande do Sul</SelectItem>
                            <SelectItem value="PR">Paraná</SelectItem>
                            <SelectItem value="SC">Santa Catarina</SelectItem>
                            <SelectItem value="BA">Bahia</SelectItem>
                            <SelectItem value="GO">Goiás</SelectItem>
                            <SelectItem value="PE">Pernambuco</SelectItem>
                            <SelectItem value="CE">Ceará</SelectItem>
                          </SelectContent>
                        </Select>
                      </div>
                    </div>
                  </div>

                  {/* Plano */}
                  <div className="space-y-4">
                    <h3 className="text-lg font-semibold text-gray-900 border-b pb-2">
                      Escolha seu Plano
                    </h3>
                    
                    <div>
                      <Label htmlFor="plano">Plano *</Label>
                      <Select value={formData.plano} onValueChange={(value) => handleSelectChange('plano', value)}>
                        <SelectTrigger>
                          <SelectValue placeholder="Selecione seu plano" />
                        </SelectTrigger>
                        <SelectContent>
                          <SelectItem value="basico">Plano Básico - R$ 29/mês</SelectItem>
                          <SelectItem value="premium">Plano Premium - R$ 59/mês</SelectItem>
                          <SelectItem value="familia">Plano Família - R$ 99/mês</SelectItem>
                        </SelectContent>
                      </Select>
                    </div>
                  </div>

                  {/* Termos */}
                  <div className="space-y-4">
                    <div className="flex items-start space-x-3">
                      <input
                        type="checkbox"
                        id="aceiteTermos"
                        name="aceiteTermos"
                        checked={formData.aceiteTermos}
                        onChange={handleInputChange}
                        className="mt-1 h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded"
                        required
                      />
                      <Label htmlFor="aceiteTermos" className="text-sm text-gray-600">
                        Li e aceito os <a href="#" className="text-blue-600 hover:underline">Termos de Uso</a> e a{' '}
                        <a href="#" className="text-blue-600 hover:underline">Política de Privacidade</a> do CuidaMais.vc
                      </Label>
                    </div>
                  </div>

                  <Button type="submit" className="w-full bg-blue-600 hover:bg-blue-700 text-lg py-3">
                    Finalizar Cadastro
                  </Button>
                </form>
              </CardContent>
            </Card>
          </div>

          {/* Coluna de Benefícios */}
          <div className="space-y-6">
            <div className="text-center">
              <h2 className="text-3xl font-bold text-gray-900 mb-4">
                Por que escolher o CuidaMais.vc?
              </h2>
              <p className="text-lg text-gray-600">
                Junte-se a milhares de pessoas que já confiam na nossa plataforma
              </p>
            </div>

            <div className="space-y-4">
              <Card className="border-l-4 border-l-blue-600">
                <CardContent className="p-6">
                  <div className="flex items-start space-x-4">
                    <div className="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center">
                      <Shield className="h-6 w-6 text-blue-600" />
                    </div>
                    <div>
                      <h3 className="text-lg font-semibold text-gray-900 mb-2">
                        Segurança Garantida
                      </h3>
                      <p className="text-gray-600">
                        Seus dados estão protegidos com a mais alta tecnologia de segurança. 
                        Sua privacidade é nossa prioridade.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="border-l-4 border-l-green-600">
                <CardContent className="p-6">
                  <div className="flex items-start space-x-4">
                    <div className="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center">
                      <Clock className="h-6 w-6 text-green-600" />
                    </div>
                    <div>
                      <h3 className="text-lg font-semibold text-gray-900 mb-2">
                        Agendamento Rápido
                      </h3>
                      <p className="text-gray-600">
                        Agende consultas em minutos, sem filas ou esperas. 
                        Escolha o horário que melhor se adapta à sua rotina.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="border-l-4 border-l-purple-600">
                <CardContent className="p-6">
                  <div className="flex items-start space-x-4">
                    <div className="w-12 h-12 bg-purple-100 rounded-full flex items-center justify-center">
                      <Users className="h-6 w-6 text-purple-600" />
                    </div>
                    <div>
                      <h3 className="text-lg font-semibold text-gray-900 mb-2">
                        Especialistas Qualificados
                      </h3>
                      <p className="text-gray-600">
                        Rede de profissionais certificados e experientes. 
                        Encontre o especialista ideal para o seu caso.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="border-l-4 border-l-yellow-600">
                <CardContent className="p-6">
                  <div className="flex items-start space-x-4">
                    <div className="w-12 h-12 bg-yellow-100 rounded-full flex items-center justify-center">
                      <Star className="h-6 w-6 text-yellow-600" />
                    </div>
                    <div>
                      <h3 className="text-lg font-semibold text-gray-900 mb-2">
                        Avaliação 5 Estrelas
                      </h3>
                      <p className="text-gray-600">
                        Mais de 10.000 pacientes já avaliaram nossa plataforma com 5 estrelas. 
                        Confie na experiência de quem já usou.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>
            </div>

            {/* Imagens do site */}
            <div className="space-y-4">
              <h3 className="text-xl font-semibold text-gray-900 text-center">
                Conheça nossa plataforma
              </h3>
              <div className="grid grid-cols-2 gap-4">
                <div className="bg-white rounded-lg p-4 shadow-md">
                  <div className="w-full h-32 bg-gradient-to-br from-blue-100 to-blue-200 rounded-lg mb-3 flex items-center justify-center">
                    <span className="text-blue-600 font-semibold">Dashboard</span>
                  </div>
                  <p className="text-sm text-gray-600 text-center">Interface intuitiva para agendar consultas</p>
                </div>
                <div className="bg-white rounded-lg p-4 shadow-md">
                  <div className="w-full h-32 bg-gradient-to-br from-green-100 to-green-200 rounded-lg mb-3 flex items-center justify-center">
                    <span className="text-green-600 font-semibold">Especialistas</span>
                  </div>
                  <p className="text-sm text-gray-600 text-center">Encontre o profissional ideal</p>
                </div>
                <div className="bg-white rounded-lg p-4 shadow-md">
                  <div className="w-full h-32 bg-gradient-to-br from-purple-100 to-purple-200 rounded-lg mb-3 flex items-center justify-center">
                    <span className="text-purple-600 font-semibold">Consultas</span>
                  </div>
                  <p className="text-sm text-gray-600 text-center">Agendamento online simples</p>
                </div>
                <div className="bg-white rounded-lg p-4 shadow-md">
                  <div className="w-full h-32 bg-gradient-to-br from-orange-100 to-orange-200 rounded-lg mb-3 flex items-center justify-center">
                    <span className="text-orange-600 font-semibold">Histórico</span>
                  </div>
                  <p className="text-sm text-gray-600 text-center">Acompanhe seus tratamentos</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
} 