<?php
header('Content-Type: application/json');

// Incluir configurações da API IXC (já inclui WebserviceClient e cria $api)
require_once 'confApi.php';

try {
    // Verificar se o CPF/CNPJ foi fornecido
    if (!isset($_GET['document'])) {
        throw new Exception('CPF/CNPJ não fornecido');
    }

    $document = $_GET['document'];
    
    // Aplicar máscaras como no consulta.php
    $query = $document;
    if (ctype_digit($document) && strlen($document) === 11) {
        // CPF: aplica máscara 000.000.000-00
        $query = preg_replace("/(\d{3})(\d{3})(\d{3})(\d{2})/", "$1.$2.$3-$4", $document);
    } else if (ctype_digit($document) && strlen($document) === 14) {
        // CNPJ: aplica máscara 00.000.000/0000-00
        $query = preg_replace("/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/", "$1.$2.$3/$4-$5", $document);
    }
    
    // A instância $api já está disponível do confApi.php
    
    // Parâmetros da consulta (seguindo o padrão do consulta.php)
    $params = array(
        'qtype' => 'cliente.cnpj_cpf',
        'query' => $query, // Usar $query com máscara aplicada
        'oper' => '=',
        'page' => '1',
        'rp' => '20',
        'sortname' => 'cliente.id',
        'sortorder' => 'desc',
        'grid_param' => json_encode([
            ['TB' => 'cliente.ativo', 'OP' => '=', 'P' => 'S']
        ])
    );
    
    // Fazer a consulta
    $api->get('cliente', $params);
    $retorno = $api->getRespostaConteudo(false); // false para JSON
    
    // Decodificar a resposta
    $data = json_decode($retorno, true);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Erro ao decodificar resposta da API IXC: ' . json_last_error_msg());
    }
    
    // Log para debug
    error_log("IXC API Document Original: " . $document);
    error_log("IXC API Query com Mascara: " . $query);
    error_log("IXC API Response: " . print_r($data, true));
    error_log("IXC API Raw Response: " . $retorno);
    
    // Verificar se há resultados (API IXC retorna 'registros', não 'rows')
    if (isset($data['registros']) && is_array($data['registros']) && count($data['registros']) > 0) {
        $cliente = $data['registros'][0]; // Primeiro resultado
        
        // Extrair o cliente.id (pode estar em diferentes campos)
        $clienteId = $cliente['id'] ?? $cliente['cliente.id'] ?? $cliente['cliente_id'] ?? null;
        
        if ($clienteId) {
            echo json_encode([
                'success' => true,
                'cliente_id' => $clienteId,
                'cliente_nome' => $cliente['nome'] ?? $cliente['cliente.nome'] ?? 'N/A',
                'cliente_cnpj_cpf' => $cliente['cnpj_cpf'] ?? $cliente['cliente.cnpj_cpf'] ?? 'N/A',
                'message' => 'Cliente encontrado no IXC',
                'raw_data' => $cliente // Para debug
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'error' => 'Cliente encontrado mas sem ID válido',
                'data' => $cliente,
                'raw_data' => $data
            ]);
        }
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'Cliente não encontrado no IXC',
            'document' => $document,
            'raw_data' => $data
        ]);
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => 'Erro na consulta IXC: ' . $e->getMessage()
    ]);
}
?>
