<?php
    include_once("confApi.php");

    $id_cliente = filter_input(INPUT_GET, 'id');
    $id_cliente = trim($id_cliente);
    $qtype = 'cliente.cnpj_cpf';
    $query = $id_cliente;
    // Detecta se é ID numérico puro
    if (ctype_digit($id_cliente) && (strlen($id_cliente) < 11)) {
        $qtype = 'cliente.id';
    } else if (ctype_digit($id_cliente) && strlen($id_cliente) === 11) {
        // CPF: aplica máscara 000.000.000-00
        $query = preg_replace("/(\d{3})(\d{3})(\d{3})(\d{2})/", "$1.$2.$3-$4", $id_cliente);
    } else if (ctype_digit($id_cliente) && strlen($id_cliente) === 14) {
        // CNPJ: aplica máscara 00.000.000/0000-00
        $query = preg_replace("/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/", "$1.$2.$3/$4-$5", $id_cliente);
    }
    $params = array(
        'qtype' => $qtype,
        'query' => "$query",
        'oper' => '=',
        'page' => '1',
        'rp' => '20',
        'sortname' => 'cliente.id',
        'sortorder' => 'desc',
        'grid_param' => json_encode([
            ['TB' => 'cliente.ativo', 'OP' => '=', 'P' => 'S']
        ])
    );
    $api->get('cliente', $params);
    $retorno = $api->getRespostaConteudo(false);// false para json | true para array
    echo $retorno;
    die();