#!/bin/bash

echo "⏰ Configurando cron job no servidor remoto..."
echo "================================================"

# Configurações do servidor
SERVER_IP="192.168.2.16"
SERVER_PORT="60111"
SERVER_USER="root"

echo "📋 Passo 1: Conectando ao servidor..."
ssh -p "$SERVER_PORT" "$SERVER_USER@$SERVER_IP" << 'EOF'

echo "📋 Passo 2: Verificando cron atual..."
crontab -l

echo ""
echo "📋 Passo 3: Adicionando cron job para teste_bloqueio.php..."
# Adicionar cron job para executar a cada 5 minutos
(crontab -l 2>/dev/null; echo "*/5 * * * * /usr/bin/php /var/www/sistema/teste_bloqueio.php >> /var/www/sistema/logs/cron.log 2>&1") | crontab -

echo ""
echo "📋 Passo 4: Verificando cron job adicionado..."
crontab -l

echo ""
echo "📋 Passo 5: Criando diretório de logs se não existir..."
mkdir -p /var/www/sistema/logs

echo ""
echo "📋 Passo 6: Testando execução do script..."
cd /var/www/sistema
php -f teste_bloqueio.php

echo ""
echo "📋 Passo 7: Verificando permissões..."
ls -la /var/www/sistema/teste_bloqueio.php
ls -la /var/www/sistema/logs/

echo ""
echo "🎉 Cron job configurado com sucesso!"
echo "⏰ Executará a cada 5 minutos"
echo "📝 Logs em: /var/www/sistema/logs/cron.log"
echo "🔧 Script: /var/www/sistema/teste_bloqueio.php"

EOF

echo ""
echo "================================================"
echo "✅ Cron job configurado no servidor remoto!"
echo "⏰ Execução: A cada 5 minutos"
echo "📝 Logs: /var/www/sistema/logs/cron.log"
echo "================================================"
