<?php
// Core3Chip - Sistema de Consulta de Clientes
$currentTime = date('H:i:s');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Core3Chip - Consulta de Clientes</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            background: linear-gradient(135deg, #0f2027 0%, #2c5364 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            margin: 0;
        }
        .container {
            background: rgba(255,255,255,0.97);
            border-radius: 32px;
            box-shadow: 0 8px 40px 0 rgba(37,99,235,0.18), 0 1.5px 8px 0 rgba(16,185,129,0.10);
            padding: 56px 40px 48px 40px;
            max-width: 520px;
            width: 100%;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 36px;
            position: relative;
        }
        .logo-img {
            width: 195px;
            height: 130px;
            object-fit: contain;
            object-position: center;
            margin-bottom: 12px;
            filter: drop-shadow(0 4px 24px #2563eb33);
            background: transparent;
            border-radius: 18px;
        }
        .search-section {
            width: 100%;
            background: #f1f5f9;
            border-radius: 18px;
            padding: 24px 18px 18px 18px;
            box-shadow: 0 2px 12px 0 rgba(37,99,235,0.06);
            margin-bottom: 10px;
        }
        .search-title h2 {
            font-size: 1.3rem;
            font-weight: 700;
            color: #2563eb;
            margin: 0 0 4px 0;
        }
        .search-title p {
            font-size: 1rem;
            color: #64748b;
            margin: 0 0 18px 0;
        }
        .search-form {
            display: flex;
            flex-direction: column;
            gap: 14px;
        }
        .form-group {
            display: flex;
            flex-direction: column;
            gap: 6px;
        }
        .form-label {
            font-size: 0.98rem;
            color: #1e293b;
            font-weight: 500;
        }
        .form-input {
            padding: 12px 14px;
            border-radius: 8px;
            border: 1.5px solid #cbd5e1;
            font-size: 1.08rem;
            outline: none;
            transition: border 0.2s;
        }
        .form-input:focus {
            border: 1.5px solid #2563eb;
        }
        .search-btn {
            padding: 13px 0;
            border: none;
            border-radius: 10px;
            font-size: 1.08rem;
            font-weight: 600;
            color: #fff;
            background: linear-gradient(90deg, #2563eb 0%, #10b981 100%);
            box-shadow: 0 2px 12px 0 rgba(37,99,235,0.10);
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            transition: background 0.2s, transform 0.2s, box-shadow 0.2s;
            outline: none;
            letter-spacing: 0.5px;
        }
        .search-btn .material-icons {
            font-size: 1.3em;
            vertical-align: middle;
        }
        .search-btn:hover {
            background: linear-gradient(90deg, #10b981 0%, #2563eb 100%);
            transform: translateY(-2px) scale(1.03);
            box-shadow: 0 6px 24px 0 rgba(16,185,129,0.13);
        }
        .loading {
            display: none;
            align-items: center;
            flex-direction: column;
            gap: 10px;
            margin: 18px 0;
        }
        .spinner {
            width: 32px;
            height: 32px;
            border: 4px solid #e0e7ef;
            border-top: 4px solid #2563eb;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .error-message, .success-message {
            display: none;
            margin: 10px 0 0 0;
            padding: 10px 18px;
            border-radius: 8px;
            font-size: 1.02rem;
            font-weight: 500;
        }
        .error-message {
            background: #fee2e2;
            color: #b91c1c;
            border: 1.5px solid #f87171;
        }
        .success-message {
            background: #d1fae5;
            color: #065f46;
            border: 1.5px solid #10b981;
        }
        .results-section {
            width: 100%;
            background: #f8fafc;
            border-radius: 18px;
            padding: 24px 18px 18px 18px;
            box-shadow: 0 2px 12px 0 rgba(37,99,235,0.06);
            margin-top: 10px;
        }
        .results-title {
            font-size: 1.15rem;
            font-weight: 700;
            color: #2563eb;
            margin: 0 0 18px 0;
        }
        .client-form {
            width: 100%;
        }
        .form-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 14px 18px;
        }
        .form-field {
            display: flex;
            flex-direction: column;
            gap: 4px;
        }
        .field-label {
            font-size: 0.97rem;
            color: #1e293b;
            font-weight: 500;
        }
        .field-value {
            padding: 10px 10px;
            border-radius: 7px;
            border: 1.2px solid #cbd5e1;
            font-size: 1.01rem;
            outline: none;
            background: #fff;
            color: #222;
            transition: border 0.2s;
        }
        .field-value:focus {
            border: 1.2px solid #2563eb;
        }
        .back-btn {
            position: absolute;
            top: 18px;
            left: 18px;
            background: linear-gradient(90deg, #2563eb 0%, #10b981 100%);
            color: #fff;
            border: none;
            border-radius: 8px;
            padding: 10px 18px;
            font-size: 1rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 8px;
            box-shadow: 0 2px 8px 0 rgba(37,99,235,0.10);
            cursor: pointer;
            transition: background 0.2s, box-shadow 0.2s;
            z-index: 10;
        }
        .back-btn .material-icons {
            font-size: 1.2em;
        }
        .back-btn:hover {
            background: linear-gradient(90deg, #10b981 0%, #2563eb 100%);
            box-shadow: 0 6px 18px 0 rgba(16,185,129,0.13);
        }
        @media (max-width: 700px) {
            .container {
                padding: 24px 4px 18px 4px;
                border-radius: 18px;
            }
            .logo-img {
                width: 130px;
                height: 91px;
            }
            .form-grid {
                grid-template-columns: 1fr;
            }
            .back-btn {
                top: 8px;
                left: 8px;
                padding: 8px 12px;
                font-size: 0.95rem;
            }
        }
        .erro-campo {
            border: 2px solid #e11d48 !important;
            box-shadow: 0 0 0 2px #fca5a5;
            animation: shake 0.2s 2;
        }
        @keyframes shake {
            0% { transform: translateX(0); }
            25% { transform: translateX(-4px); }
            50% { transform: translateX(4px); }
            75% { transform: translateX(-4px); }
            100% { transform: translateX(0); }
        }
    </style>
</head>
<body>
    <div style="position:absolute;top:18px;right:24px;z-index:100;">
        <a href="logout.php" style="background:linear-gradient(90deg,#e11d48 0%,#f87171 100%);color:#fff;padding:10px 22px;border-radius:8px;font-weight:600;text-decoration:none;box-shadow:0 2px 8px #e11d4811;display:flex;align-items:center;gap:8px;font-size:1.05em;">
            <span class="material-icons" style="font-size:1.2em;">logout</span> Sair
        </a>
    </div>
    <div class="container">
        <button onclick="window.location.href='index.php'" class="back-btn">
            <span class="material-icons">arrow_back</span> Voltar
        </button>
        <!-- Header com Logo -->
        <header class="header">
            <div class="menu-bar">
                <div class="logo-area">
                    <img src="chip.png" alt="Logo" class="logo-img" />
                </div>
            </div>
        </header>
        <!-- Seção de Busca -->
        <div class="search-section">
            <div class="search-title">
                <h2>🔍 Consulta de Clientes</h2>
                <p>Digite o CPF, CNPJ ou ID do cliente para buscar informações</p>
            </div>
            <form class="search-form" id="searchForm">
                <div class="form-group">
                    <label class="form-label">CPF, CNPJ ou ID</label>
                    <input type="text" class="form-input" id="documentInput" placeholder="Digite CPF, CNPJ ou ID (máscara automática)" required>
                </div>
                <button type="submit" class="search-btn" id="searchBtn">
                    <span class="material-icons">search</span>
                    Consultar Cliente
                </button>
                <button type="button" class="search-btn" id="insertBtn" style="background: linear-gradient(135deg, #10b981, #059669);">
                    <span class="material-icons">person_add</span>
                    Inserir Cliente
                </button>
            </form>
        </div>
        <!-- Loading -->
        <div class="loading" id="loading">
            <div class="spinner"></div>
            <p>Consultando dados do cliente...</p>
        </div>
        <!-- Mensagens -->
        <div class="error-message" id="errorMessage"></div>
        <div class="success-message" id="successMessage"></div>
        <!-- Seção de Resultados -->
        <div class="results-section" id="resultsSection">
            <h2 class="results-title">📊 Dados do Cliente</h2>
            <div class="client-form">
                <form id="clientForm">
                    <div class="form-grid">
                        <div class="form-field">
                            <label class="field-label">🆔 ID do Cliente</label>
                            <input class="field-value" id="clientId" name="clientId" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">👤 Nome/Razão Social</label>
                            <input class="field-value" id="clientName" name="clientName" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📄 CPF/CNPJ</label>
                            <input class="field-value" id="clientDocument" name="clientDocument" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📧 Email</label>
                            <input class="field-value" id="clientEmail" name="clientEmail" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📱 Telefone</label>
                            <input class="field-value" id="clientPhone" name="clientPhone" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">✅ Status</label>
                            <input class="field-value" id="clientStatus" name="clientStatus" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📅 Data de Cadastro</label>
                            <input class="field-value" id="clientCreated" name="clientCreated" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🔄 Última Atualização</label>
                            <input class="field-value" id="clientUpdated" name="clientUpdated" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🎂 Data de Nascimento</label>
                            <input class="field-value" id="clientBirthDate" name="clientBirthDate" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📍 Endereço</label>
                            <input class="field-value" id="clientAddress" name="clientAddress" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🔢 Número</label>
                            <input class="field-value" id="clientNumber" name="clientNumber" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🏘️ Bairro</label>
                            <input class="field-value" id="clientNeighborhood" name="clientNeighborhood" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🏙️ Cidade</label>
                            <input class="field-value" id="clientCity" name="clientCity" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🌍 Estado</label>
                            <input class="field-value" id="clientState" name="clientState" type="text" value="-" maxlength="2" style="text-transform:uppercase;" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📮 CEP</label>
                            <input class="field-value" id="clientZipCode" name="clientZipCode" type="text" value="-" />
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- Botão atualizar dados do cliente -->
        <!-- Removido conforme solicitado -->
    </div>
    <script>
// --- Máscara Inteligente CPF/CNPJ ---
function applyCPFMask(value) {
    return value.replace(/(\d{3})(\d)/, '$1.$2')
        .replace(/(\d{3})(\d)/, '$1.$2')
        .replace(/(\d{3})(\d{1,2})$/, '$1-$2');
}
function applyCNPJMask(value) {
    return value.replace(/(\d{2})(\d)/, '$1.$2')
        .replace(/(\d{3})(\d)/, '$1.$2')
        .replace(/(\d{3})(\d)/, '$1/$2')
        .replace(/(\d{4})(\d{1,2})$/, '$1-$2');
}
const documentInput = document.getElementById('documentInput');
documentInput.addEventListener('input', function(e) {
    let value = e.target.value.replace(/\D/g, '');
    if (value.length <= 11) {
        e.target.value = applyCPFMask(value);
    } else if (value.length <= 14) {
        e.target.value = applyCNPJMask(value);
    } else {
        e.target.value = value;
    }
});
// --- Consulta Cliente ---
const searchForm = document.getElementById('searchForm');
const loading = document.getElementById('loading');
const errorMessage = document.getElementById('errorMessage');
const successMessage = document.getElementById('successMessage');
const resultsSection = document.getElementById('resultsSection');
const clientForm = document.getElementById('clientForm');
searchForm.addEventListener('submit', function(e) {
    e.preventDefault();
    errorMessage.style.display = 'none';
    successMessage.style.display = 'none';
    loading.style.display = 'flex';
    resultsSection.style.display = 'none';
    const documentValue = documentInput.value.replace(/\D/g, '');
    const url = 'consulta.php?id=' + encodeURIComponent(documentValue);
    fetch(url)
        .then(async response => {
            const text = await response.text();
            let data;
            try {
                data = JSON.parse(text);
            } catch (e) {
                if (text.includes('<form') && text.includes('login')) {
                    window.location.href = 'login.php';
                    return;
                }
                errorMessage.textContent = 'Sessão expirada ou erro inesperado. Faça login novamente.';
                errorMessage.style.display = 'block';
                loading.style.display = 'none';
                return;
            }
            return data;
        })
        .then(data => {
            if (!data) return;
            loading.style.display = 'none';
            if (!data.registros || !data.registros[0]) {
                errorMessage.textContent = 'Cliente não encontrado.';
                errorMessage.style.display = 'block';
                return;
            }
            const cliente = data.registros[0];
            document.getElementById('clientId').value = cliente.id || '-';
            document.getElementById('clientName').value = cliente.razao || cliente.fantasia || '-';
            document.getElementById('clientDocument').value = cliente.cnpj_cpf || '-';
            document.getElementById('clientEmail').value = cliente.email || '-';
            document.getElementById('clientPhone').value = cliente.fone || cliente.telefone_celular || '-';
            document.getElementById('clientStatus').value = cliente.status || '-';
            document.getElementById('clientCreated').value = cliente.data_cadastro || '-';
            document.getElementById('clientUpdated').value = cliente.data_alteracao || '-';
            document.getElementById('clientBirthDate').value = cliente.data_nascimento || '-';
            document.getElementById('clientAddress').value = cliente.endereco || '-';
            document.getElementById('clientNumber').value = cliente.numero || '-';
            document.getElementById('clientNeighborhood').value = cliente.bairro || '-';
            document.getElementById('clientCity').value = cliente.cidade || '-';
            document.getElementById('clientState').value = cliente.uf || '-';
            document.getElementById('clientZipCode').value = cliente.cep || '-';
            resultsSection.style.display = 'block';
        })
        .catch(err => {
            loading.style.display = 'none';
            errorMessage.textContent = 'Erro ao consultar cliente: ' + err.message;
            errorMessage.style.display = 'block';
        });
});
// --- Inserir Cliente ---
document.getElementById('insertBtn').addEventListener('click', function() {
    errorMessage.style.display = 'none';
    successMessage.style.display = 'none';
    loading.style.display = 'flex';
    let client = {};
    // Função para filtrar apenas letras e espaços
    function soLetrasEspacos(str) {
        return str ? str.normalize('NFD').replace(/[^\p{L} ]+/gu, '').replace(/\s+/g, ' ').trim() : '';
    }
    let cidadeBruta = document.getElementById('clientCity').value.trim();
    if (cidadeBruta === '1956') cidadeBruta = 'Feira de Santana';
    else if (cidadeBruta === '3374') cidadeBruta = 'Campinas';
    else if (cidadeBruta === '2160') cidadeBruta = 'Salinas das Margaridas';
    else if (cidadeBruta === '2238') cidadeBruta = 'Vitoria da Conquista';
    else if (cidadeBruta === '2161') cidadeBruta = 'Salvador';
    else if (cidadeBruta === '2236') cidadeBruta = 'Vera Cruz';
    else if (cidadeBruta === '2016') cidadeBruta = 'Itaparica';
    else if (cidadeBruta === '2184') cidadeBruta = 'Sao Goncalo dos Campos';
    else if (cidadeBruta === '1896') cidadeBruta = 'Camacari';
    let cidadeValor = soLetrasEspacos(cidadeBruta);
    let ufValor = document.getElementById('clientState').value.toUpperCase();
    if (ufValor === '10') ufValor = 'BA';
    else if (ufValor === '1') ufValor = 'SP';
    const map = {
        iccid: '',
        name: soLetrasEspacos(document.getElementById('clientName').value),
        email: document.getElementById('clientEmail').value,
        document: document.getElementById('clientDocument').value.replace(/\D/g, ''),
        birthDate: document.getElementById('clientBirthDate').value,
        phone: '55' + document.getElementById('clientPhone').value.replace(/\D/g, '').slice(-11),
        zipcode: document.getElementById('clientZipCode').value.replace(/\D/g, ''),
        number: document.getElementById('clientNumber').value,
        complement: soLetrasEspacos(document.getElementById('clientAddress').value),
        street: soLetrasEspacos(document.getElementById('clientAddress').value),
        neighborhood: soLetrasEspacos(document.getElementById('clientNeighborhood').value),
        city: cidadeValor,
        uf: ufValor,
        reference: soLetrasEspacos('')
    };
    Object.entries(map).forEach(([k, v]) => {
        let valor = v ? String(v) : '';
        if (k === 'birthDate' && (valor === '0000-00-00' || valor === '-')) valor = '';
        if (typeof valor === 'string' && valor.length > 41) valor = valor.slice(0, 41);
        client[k] = valor;
    });
    if (client.zipcode.length !== 8) {
        loading.style.display = 'none';
        errorMessage.textContent = 'CEP deve conter 8 dígitos numéricos.';
        errorMessage.style.display = 'block';
        return;
    }
    fetch('inserir-cliente.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(client)
    })
    .then(async response => {
        let data;
        try {
            data = await response.json();
        } catch (e) {
            data = { error: 'Resposta inválida do servidor.' };
        }
        loading.style.display = 'none';
        // Mapeamento de nomes de campos para português amigável
        const camposPt = {
            name: 'Nome/Razão Social',
            street: 'Endereço',
            neighborhood: 'Bairro',
            city: 'Cidade',
            complement: 'Complemento',
            reference: 'Referência',
            birthDate: 'Data de Nascimento',
            document: 'CPF/CNPJ',
            email: 'E-mail',
            phone: 'Telefone',
            zipcode: 'CEP',
            number: 'Número',
            uf: 'Estado'
        };
        // Função para remover destaques de erro
        function limparDestaques() {
            document.querySelectorAll('.field-value').forEach(el => {
                el.classList.remove('erro-campo');
            });
        }
        if (!response.ok || data.error || data.detail || data.errors) {
            let msg = data.detail || data.error || 'Erro desconhecido';
            let campoDestaque = null;
            if (data.errors && typeof data.errors === 'object') {
                msg = '';
                for (const campo in data.errors) {
                    let nomeCampo = campo.replace(/^\$\./, '');
                    let label = camposPt[nomeCampo] || nomeCampo;
                    if (!campoDestaque) campoDestaque = nomeCampo;
                    if (Array.isArray(data.errors[campo])) {
                        msg += `• ${label}: ${data.errors[campo].join(' ')}\n`;
                    } else {
                        msg += `• ${label}: ${data.errors[campo]}\n`;
                    }
                }
                msg = msg.trim();
            }
            errorMessage.innerHTML = '<b>Corrija os campos destacados abaixo:</b><br>' + msg.replace(/\n/g, '<br>');
            errorMessage.style.display = 'block';
            // Destacar campo problemático
            if (campoDestaque) {
                const el = document.getElementById('client' + campoDestaque.charAt(0).toUpperCase() + campoDestaque.slice(1));
                if (el) el.classList.add('erro-campo');
            }
        } else {
            successMessage.textContent = 'Cliente inserido com sucesso!';
            successMessage.style.display = 'block';
        }
    })
    .catch(err => {
        loading.style.display = 'none';
        errorMessage.textContent = 'Erro ao inserir cliente: ' + err.message;
        errorMessage.style.display = 'block';
    });
});
    // Remover destaque ao digitar
    document.querySelectorAll('.field-value').forEach(el => {
        el.addEventListener('input', function() {
            el.classList.remove('erro-campo');
        });
    });
    </script>
</body>
</html>
