<?php
header('Content-Type: application/json');

// Incluir o arquivo de mapeamento
require_once 'mapeamento-planos.php';

try {
    // Verificar se a ação foi solicitada
    if (!isset($_GET['acao']) || $_GET['acao'] !== 'buscar') {
        throw new Exception('Ação inválida');
    }
    
    // Verificar se o plano Boramvno foi fornecido
    if (!isset($_GET['plano_boramvno'])) {
        throw new Exception('Plano Boramvno não fornecido');
    }
    
    $planoBoramvno = $_GET['plano_boramvno'];
    
    // Buscar o plano na tabela de mapeamento
    $resultado = buscarPlanoPorBoramvno($planoBoramvno);
    
    // Retornar o resultado
    echo json_encode($resultado);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => 'Erro na busca: ' . $e->getMessage()
    ]);
}
?>
