# Funcionalidade de Alteração de Plano Após Desativação

## Resumo da Implementação

Implementei uma funcionalidade completa de alteração de plano que é ativada automaticamente após o sucesso da desativação de recorrência. O sistema oferece uma experiência fluida e intuitiva para o usuário alterar o plano do cliente.

## Fluxo da Funcionalidade

### **1. Desativação de Recorrência (Sucesso)**
```
┌─────────────────────────────────────┐
│           ✅ (Verde)                │
│      Recorrência Desativada!        │
│                                     │
│ ┌─ Detalhes da Operação ─────────┐   │
│ │ 📋 Método Utilizado: PUT       │   │
│ │ 📋 Status: Operação realizada  │   │
│ │ 📋 HTTP Code: 200              │   │
│ │ 📋 Resultado: Sucesso          │   │
│ └─────────────────────────────────┘   │
│                                     │
│ [🔄 Alterar Plano do Cliente]      │
└─────────────────────────────────────┘
```

### **2. Popup de Confirmação**
```
┌─────────────────────────────────────┐
│           🔄 (Azul)                │
│      Alterar Plano do Cliente      │
│                                     │
│ Deseja alterar o plano do cliente  │
│ 5511981913040?                     │
│                                     │
│ [Cancelar]    [Alterar Plano]      │
└─────────────────────────────────────┘
```

### **3. Seleção de Plano**
```
┌─────────────────────────────────────┐
│           📋 (Verde)               │
│        Escolher Novo Plano         │
│                                     │
│ Selecione o novo plano para o      │
│ cliente 5511981913040:             │
│                                     │
│ [Dropdown com planos disponíveis]  │
│                                     │
│ [Cancelar]    [Confirmar Troca]    │
└─────────────────────────────────────┘
```

### **4. Resultado Final**
```
┌─────────────────────────────────────┐
│           ✅ (Verde)                │
│      Plano Alterado com Sucesso!   │
│                                     │
│ ┌─ Detalhes da Operação ─────────┐   │
│ │ 📋 MSISDN: 5511981913040       │   │
│ │ 📋 CartId: 3fa85f64-5717...    │   │
│ │ 📋 Status: Processado com sucesso│   │
│ └─────────────────────────────────┘   │
└─────────────────────────────────────┘
```

## APIs Utilizadas

### **1. /api/Plan/Recharge (POST)**
- **Propósito**: Obter planos disponíveis para recarga
- **Payload**:
  ```json
  {
    "msisdn": "5511981913040",
    "type": "POS"
  }
  ```
- **Resposta**: Array de planos disponíveis

### **2. /api/Cart/recharge (POST)**
- **Propósito**: Criar carrinho de recarga
- **Payload**:
  ```json
  {
    "clientId": "321f51a9-6096-41aa-8157-76e7c188ae5b",
    "msisdn": "5511981913040",
    "planId": "d073d648-4288-4a60-9bd1-65744be518ca",
    "expiresAt": "",
    "recurrence": {
      "paymentType": "",
      "paymentId": ""
    }
  }
  ```
- **Resposta**:
  ```json
  {
    "cartId": "3fa85f64-5717-4562-b3fc-2c963f66afa6"
  }
  ```

### **3. /api/Cart/recharge/{cartId}/BilletCombo (POST)**
- **Propósito**: Processar boleto do carrinho
- **URL**: `/api/Cart/recharge/{cartId}/BilletCombo`
- **Payload**: Vazio (POST sem body)
- **Resposta**: Confirmação de processamento

## Código Implementado

### **Botão de Alterar Plano:**
```javascript
<!-- Botão para alterar plano -->
<button id="btnAlterarPlano" style="background:linear-gradient(90deg,#2563eb 0%,#7c3aed 100%);color:#fff;padding:12px 24px;border-radius:10px;font-weight:600;border:none;cursor:pointer;font-size:1.05em;margin-top:16px;">
    <span class="material-icons" style="margin-right:8px;">swap_horiz</span>
    Alterar Plano do Cliente
</button>
```

### **Event Listener Principal:**
```javascript
document.getElementById('btnAlterarPlano').onclick = async () => {
    // Capturar MSISDN do formulário
    const msisdn = document.getElementById('numeroLinha').value;
    
    if (!msisdn) {
        alert('Número da linha não encontrado. Por favor, consulte a linha primeiro.');
        return;
    }
    
    // Mostrar popup de alteração de plano
    // ... código do popup ...
};
```

### **Popup de Confirmação:**
```javascript
const popupAlterarPlano = `
    <div id="popupOverlayAlterarPlano" style="position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(30,41,59,0.55);z-index:9999;display:flex;align-items:center;justify-content:center;">
        <div id="popupAlterarPlano" style="background:#fff;border-radius:18px;box-shadow:0 8px 40px 0 rgba(37,99,235,0.18);padding:32px;max-width:600px;width:90vw;text-align:center;">
            <div style="font-size:2.5em;color:#2563eb;margin-bottom:16px;">
                <span class="material-icons">swap_horiz</span>
            </div>
            <div style="font-size:1.4em;font-weight:700;color:#2563eb;margin-bottom:16px;">
                Alterar Plano do Cliente
            </div>
            
            <div style="color:#64748b;font-size:1.05em;margin-bottom:24px;line-height:1.5;">
                Deseja alterar o plano do cliente ${msisdn}?
            </div>
            
            <div style="display:flex;gap:12px;justify-content:center;">
                <button id="btnCancelarAlterarPlano" style="background:#f1f5f9;color:#64748b;padding:12px 24px;border-radius:10px;font-weight:600;border:none;cursor:pointer;font-size:1.05em;">
                    Cancelar
                </button>
                <button id="btnConfirmarAlterarPlano" style="background:linear-gradient(90deg,#10b981 0%,#2563eb 100%);color:#fff;padding:12px 24px;border-radius:10px;font-weight:600;border:none;cursor:pointer;font-size:1.05em;">
                    Alterar Plano
                </button>
            </div>
        </div>
    </div>
`;
```

### **Dropdown de Planos:**
```javascript
<select id="selectPlano" style="width:100%;padding:12px;border:2px solid #e2e8f0;border-radius:10px;font-size:1.05em;background:#fff;">
    <option value="">Selecione um plano...</option>
    ${dataPlanos.map(plano => `
        <option value="${plano.id || plano.planId}" data-nome="${plano.name || plano.planName}" data-valor="${plano.value || plano.planValue}">
            ${plano.name || plano.planName} - R$ ${((plano.value || plano.planValue) / 100).toFixed(2)}
        </option>
    `).join('')}
</select>
```

## Funcionalidades Implementadas

### **1. Captura Automática de MSISDN**
- **Fonte**: Campo `numeroLinha` do formulário
- **Validação**: Verifica se existe antes de prosseguir
- **Fallback**: Alerta se não encontrado

### **2. Popup de Confirmação**
- **Design**: Material Design com gradiente azul
- **Botões**: Cancelar (cinza) e Alterar Plano (gradiente)
- **Responsivo**: Adapta-se a diferentes tamanhos de tela

### **3. Carregamento de Planos**
- **API**: `/api/Plan/Recharge`
- **Parâmetros**: MSISDN e Type (POS)
- **Tratamento**: Erro se falhar ao carregar

### **4. Seleção de Plano**
- **Dropdown**: Lista todos os planos disponíveis
- **Formato**: Nome do Plano - R$ Valor
- **Validação**: Obrigatório selecionar antes de confirmar

### **5. Processamento Automático**
- **Carrinho**: Cria automaticamente via `/api/Cart/recharge`
- **Boleto**: Processa automaticamente via `/api/Cart/recharge/{cartId}/BilletCombo`
- **Sequência**: Executa em ordem sem intervenção do usuário

### **6. Feedback Visual**
- **Estados**: Carregando, Processando, Sucesso, Erro
- **Cores**: Azul (processando), Verde (sucesso), Vermelho (erro)
- **Ícones**: Material Icons para cada estado

## Tratamento de Erros

### **1. Erro ao Carregar Planos**
- **Causa**: Falha na API `/api/Plan/Recharge`
- **Ação**: Remove popup e mostra erro
- **Mensagem**: "Erro ao Carregar Planos"

### **2. Erro na Criação do Carrinho**
- **Causa**: Falha na API `/api/Cart/recharge`
- **Ação**: Remove popup de planos e mostra erro
- **Mensagem**: "Erro na Alteração do Plano"

### **3. Erro no Processamento do Boleto**
- **Causa**: Falha na API `/api/Cart/recharge/{cartId}/BilletCombo`
- **Ação**: Remove popup e mostra erro
- **Mensagem**: "Erro na Alteração do Plano"

### **4. Validações Frontend**
- **MSISDN**: Verifica se existe no formulário
- **Plano**: Verifica se foi selecionado
- **Feedback**: Alerta imediato para validações

## Estados da Interface

### **Estado Inicial**
- **Botão**: "Alterar Plano do Cliente" (ativo)
- **Cor**: Gradiente azul-roxo
- **Ícone**: swap_horiz

### **Estado Carregando**
- **Botão**: "Carregando..." (desabilitado)
- **Cor**: Mantém estilo original
- **Ícone**: hourglass_top

### **Estado Processando**
- **Botão**: "Processando..." (desabilitado)
- **Cor**: Mantém estilo original
- **Ícone**: hourglass_top

### **Estado Sucesso**
- **Interface**: Mensagem de sucesso completa
- **Cores**: Verde para sucesso
- **Ícone**: check_circle

### **Estado Erro**
- **Interface**: Mensagem de erro específica
- **Cores**: Vermelho para erro
- **Ícone**: error

## Benefícios da Implementação

### **1. Experiência do Usuário**
- **Fluxo intuitivo**: Sequência lógica de ações
- **Feedback visual**: Estados claros em cada etapa
- **Automação**: Processamento automático das APIs

### **2. Funcionalidade Completa**
- **Cobertura total**: Todas as APIs necessárias implementadas
- **Validações**: Frontend e backend
- **Tratamento de erros**: Robusto e informativo

### **3. Integração Seamless**
- **Após desativação**: Ativação automática da funcionalidade
- **Contexto mantido**: MSISDN capturado automaticamente
- **Transições suaves**: Entre diferentes estados

## Como Testar

### **1. Fluxo Completo**
1. **Desativar recorrência** com sucesso
2. **Aguardar 1.5s** para interface limpa
3. **Clicar** em "Alterar Plano do Cliente"
4. **Confirmar** no popup de confirmação
5. **Selecionar** plano no dropdown
6. **Confirmar troca** e aguardar processamento
7. **Verificar** mensagem de sucesso

### **2. Validações**
- **Sem MSISDN**: Deve mostrar alerta
- **Sem plano selecionado**: Deve mostrar alerta
- **Erro de API**: Deve mostrar mensagem específica

### **3. Estados Visuais**
- **Carregando**: Botões desabilitados com texto apropriado
- **Processando**: Feedback visual durante operações
- **Sucesso/Erro**: Mensagens claras e específicas

## Status da Implementação

✅ **Botão de alterar plano implementado**
✅ **Popup de confirmação criado**
✅ **API de planos integrada**
✅ **Dropdown de seleção implementado**
✅ **APIs de carrinho integradas**
✅ **Processamento automático implementado**
✅ **Tratamento de erros robusto**
✅ **Interface responsiva e elegante**

## Notas Técnicas

### **Compatibilidade:**
- **Navegadores**: Suporte completo
- **JavaScript**: ES6+ (async/await)
- **CSS**: Material Design responsivo

### **Performance:**
- **APIs sequenciais**: Executadas em ordem
- **Feedback imediato**: Estados visuais em tempo real
- **Cleanup automático**: Popups removidos após uso

### **Manutenibilidade:**
- **Código modular**: Funções bem estruturadas
- **Tratamento de erros**: Centralizado e consistente
- **Validações**: Frontend e backend

A funcionalidade de alteração de plano oferece uma **experiência completa e profissional**, integrando-se perfeitamente ao fluxo de desativação de recorrência!
