# 🚀 Deploy no Servidor Remoto - Sistema Core3Chip

Este documento explica como fazer o deploy completo do sistema no servidor remoto para funcionar exatamente igual ao ambiente local.

## 📋 Pré-requisitos

- ✅ Acesso SSH ao servidor remoto (192.168.2.16:60111)
- ✅ Usuário root no servidor
- ✅ Todos os arquivos do sistema no diretório local
- ✅ Conexão de internet estável

## 🎯 Objetivo

Configurar o servidor remoto com:
- PHP 7.3 (compatível com o código)
- Apache configurado corretamente
- Todas as extensões necessárias
- Sistema funcionando em http://192.168.2.16/sistema
- Cron job configurado
- Banco de dados MySQL conectado

## 📁 Arquivos Criados

### 1. `config_servidor_remoto.php`
- Configuração específica para o servidor remoto
- Conecta ao banco MySQL em 192.168.2.129
- Configurações de produção
- Logs centralizados

### 2. `configurar_servidor_remoto.sh`
- Script para configurar o servidor
- Instala PHP 7.3 e extensões
- Configura Apache
- Cria diretórios necessários

### 3. `upload_para_servidor.sh`
- Script para upload dos arquivos
- Compacta e envia via SCP
- Descompacta no servidor
- Ajusta permissões

### 4. `configurar_cron_remoto.sh`
- Configura cron job para teste_bloqueio.php
- Executa a cada 5 minutos
- Cria diretório de logs

### 5. `deploy_completo.sh`
- Script principal que executa tudo
- Interface interativa
- Testes automáticos
- Relatório final

## 🚀 Como Executar

### Opção 1: Deploy Completo (Recomendado)
```bash
chmod +x deploy_completo.sh
./deploy_completo.sh
```

### Opção 2: Deploy Manual
```bash
# 1. Configurar servidor
chmod +x configurar_servidor_remoto.sh
./configurar_servidor_remoto.sh

# 2. Fazer upload
chmod +x upload_para_servidor.sh
./upload_para_servidor.sh

# 3. Configurar cron
chmod +x configurar_cron_remoto.sh
./configurar_cron_remoto.sh
```

## 📋 Passos do Deploy

### FASE 1: Configuração do Servidor
- ✅ Reverte sources.list para Debian 10
- ✅ Instala PHP 7.3 e extensões
- ✅ Configura Apache (mod_rewrite, AllowOverride)
- ✅ Cria diretórios do sistema
- ✅ Ajusta permissões

### FASE 2: Upload dos Arquivos
- ✅ Verifica arquivos essenciais
- ✅ Compacta em tar.gz
- ✅ Envia via SCP
- ✅ Descompacta no servidor
- ✅ Ajusta permissões

### FASE 3: Configuração do Cron
- ✅ Adiciona cron job
- ✅ Executa a cada 5 minutos
- ✅ Cria diretório de logs
- ✅ Testa execução

### FASE 4: Teste Final
- ✅ Testa resposta HTTP
- ✅ Verifica configuração PHP
- ✅ Relatório de status

## 🔧 Configurações do Servidor

### PHP 7.3
- memory_limit = 256M
- max_execution_time = 300
- upload_max_filesize = 50M
- post_max_size = 50M
- display_errors = Off
- log_errors = On
- date.timezone = America/Sao_Paulo

### Apache
- DocumentRoot: /var/www
- AllowOverride: All
- mod_rewrite: Ativo
- mod_headers: Ativo

### Diretórios
- Sistema: /var/www/sistema
- Logs: /var/www/sistema/logs
- Link simbólico: /var/www/html/sistema

## 🌐 URLs e Acesso

- **Sistema**: http://192.168.2.16/sistema
- **SSH**: ssh -p 60111 root@192.168.2.16
- **Banco**: 192.168.2.129:3306 (ixcprovedor)

## 📝 Logs e Monitoramento

### Logs do Sistema
- PHP errors: `/var/www/sistema/logs/php_errors.log`
- API: `/var/www/sistema/logs/api.log`
- Cron: `/var/www/sistema/logs/cron.log`

### Comandos Úteis
```bash
# Ver logs em tempo real
tail -f /var/www/sistema/logs/cron.log

# Status do Apache
systemctl status apache2

# Verificar cron jobs
crontab -l

# Testar PHP
php -v
php -m | grep -E "(curl|mysql|json)"
```

## 🚨 Solução de Problemas

### Erro: PHP não encontrado
```bash
# Reinstalar PHP 7.3
apt-get install -y --reinstall php7.3-common php7.3-cli libapache2-mod-php7.3
```

### Erro: Apache não responde
```bash
# Verificar status
systemctl status apache2

# Reiniciar
systemctl restart apache2

# Verificar configuração
apache2ctl configtest
```

### Erro: Permissões negadas
```bash
# Ajustar permissões
chown -R www-data:www-data /var/www/sistema
chmod -R 755 /var/www/sistema
```

### Erro: Cron não executa
```bash
# Verificar cron
crontab -l

# Verificar logs
tail -f /var/www/sistema/logs/cron.log

# Testar manualmente
php /var/www/sistema/teste_bloqueio.php
```

## ✅ Checklist de Verificação

- [ ] Servidor configurado (PHP 7.3, Apache)
- [ ] Arquivos enviados e descompactados
- [ ] Permissões ajustadas
- [ ] Cron job configurado
- [ ] Sistema respondendo HTTP 200
- [ ] Login funcionando
- [ ] APIs IXC funcionando
- [ ] Banco MySQL conectando
- [ ] Logs sendo gerados

## 🎉 Resultado Final

Após o deploy bem-sucedido, você terá:

1. **Sistema funcionando** em http://192.168.2.16/sistema
2. **Mesma funcionalidade** do ambiente local
3. **Cron job automático** para bloqueio de recorrência
4. **Logs centralizados** para monitoramento
5. **Configuração de produção** otimizada

## 📞 Suporte

Se encontrar problemas:
1. Verifique os logs em `/var/www/sistema/logs/`
2. Execute os comandos de verificação
3. Consulte a seção de solução de problemas
4. Verifique se todas as extensões PHP estão instaladas

---

**🎯 Sistema Core3Chip - Deploy Remoto Completo**
